/*
 * Decompiled with CFR 0.152.
 */
package io.circe.numbers;

import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.SigAndExp;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class BiggerDecimal$
implements Serializable {
    public static BiggerDecimal$ MODULE$;
    private final BigInteger MaxBigIntegerDigits;
    private final BigInteger MaxInt;
    private final BigInteger MinInt;
    private final BigDecimal MaxLong;
    private final BigDecimal MinLong;
    private final BiggerDecimal UnsignedZero;
    private final BiggerDecimal NegativeZero;

    static {
        new BiggerDecimal$();
    }

    public BigInteger MaxBigIntegerDigits() {
        return this.MaxBigIntegerDigits;
    }

    public BigInteger MaxInt() {
        return this.MaxInt;
    }

    public BigInteger MinInt() {
        return this.MinInt;
    }

    public BigDecimal MaxLong() {
        return this.MaxLong;
    }

    public BigDecimal MinLong() {
        return this.MinLong;
    }

    public BiggerDecimal NegativeZero() {
        return this.NegativeZero;
    }

    private BiggerDecimal fromUnscaledAndScale(BigInteger unscaled, long scale) {
        if (BoxesRunTime.equalsNumNum((Number)unscaled, (Number)BigInteger.ZERO)) {
            return this.UnsignedZero;
        }
        BigInteger current = unscaled;
        long depth = scale;
        BigInteger[] divAndRem = current.divideAndRemainder(BigInteger.TEN);
        while (BoxesRunTime.equalsNumNum((Number)divAndRem[1], (Number)BigInteger.ZERO)) {
            current = divAndRem[0];
            --depth;
            divAndRem = current.divideAndRemainder(BigInteger.TEN);
        }
        return new SigAndExp(current, BigInteger.valueOf(depth));
    }

    public BiggerDecimal fromBigInteger(BigInteger i) {
        return this.fromUnscaledAndScale(i, 0L);
    }

    public BiggerDecimal fromBigDecimal(BigDecimal d) {
        return this.fromUnscaledAndScale(d.unscaledValue(), d.scale());
    }

    public BiggerDecimal fromLong(long d) {
        return this.fromUnscaledAndScale(BigInteger.valueOf(d), 0L);
    }

    public BiggerDecimal fromDoubleUnsafe(double d) {
        if (Double.compare(d, -0.0) == 0) {
            return this.NegativeZero();
        }
        return this.fromBigDecimal(BigDecimal.valueOf(d));
    }

    public BiggerDecimal fromFloat(float f) {
        if (Float.compare(f, -0.0f) == 0) {
            return this.NegativeZero();
        }
        return this.fromBigDecimal(new BigDecimal(Float.toString(f)));
    }

    public boolean integralIsValidLong(String s) {
        String bound = s.charAt(0) == '-' ? "-9223372036854775808" : "9223372036854775807";
        return s.length() < bound.length() || s.length() == bound.length() && s.compareTo(bound) <= 0;
    }

    public Option<BiggerDecimal> parseBiggerDecimal(String input) {
        return Option$.MODULE$.apply((Object)this.parseBiggerDecimalUnsafe(input));
    }

    public BiggerDecimal parseBiggerDecimalUnsafe(String input) {
        String integral;
        int i;
        int len = input.length();
        if (len == 0) {
            return null;
        }
        int zeros = 0;
        int decIndex = -1;
        int expIndex = -1;
        int startIndex = i = input.charAt(0) == '-' ? 1 : 0;
        boolean parsedNonZeroIntegralDigit = false;
        if (i >= len) {
            return null;
        }
        int state = 6;
        while (i < len && state != 0) {
            char c = input.charAt(i);
            int n = state;
            switch (n) {
                case 6: {
                    if (c == '0') {
                        if (!parsedNonZeroIntegralDigit) break;
                        ++zeros;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        parsedNonZeroIntegralDigit = true;
                        zeros = 0;
                        break;
                    }
                    if (c == '.') {
                        state = 1;
                        break;
                    }
                    if ((c == 'e' || c == 'E') && i != startIndex) {
                        state = 3;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 1: {
                    decIndex = i - 1;
                    if (c == '0') {
                        ++zeros;
                        state = 2;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        zeros = 0;
                        state = 2;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    expIndex = i - 1;
                    if (c >= '0' && c <= '9') {
                        state = 5;
                        break;
                    }
                    if (c == '+' || c == '-') {
                        state = 4;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (c == '0') {
                        ++zeros;
                        state = 2;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        zeros = 0;
                        state = 2;
                        break;
                    }
                    if (c == 'e' || c == 'E') {
                        state = 3;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 4: {
                    if (c >= '0' && c <= '9') {
                        state = 5;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 5: {
                    if (c >= '0' && c <= '9') {
                        state = 5;
                        break;
                    }
                    state = 0;
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            ++i;
        }
        if (state == 0 || state == 1 || state == 3 || state == 4) {
            return null;
        }
        String string = decIndex >= 0 ? input.substring(0, decIndex) : (integral = expIndex == -1 ? input : input.substring(0, expIndex));
        String fractional = decIndex == -1 ? "" : (expIndex == -1 ? input.substring(decIndex + 1) : input.substring(decIndex + 1, expIndex));
        String unscaledString = new StringBuilder(0).append(integral).append(fractional).toString();
        BigInteger unscaled = new BigInteger(unscaledString.substring(0, unscaledString.length() - zeros));
        if (BoxesRunTime.equalsNumNum((Number)unscaled, (Number)BigInteger.ZERO)) {
            if (input.charAt(0) == '-') {
                return this.NegativeZero();
            }
            return this.UnsignedZero;
        }
        BigInteger rescale = BigInteger.valueOf(fractional.length() - zeros);
        BigInteger scale = expIndex == -1 ? rescale : rescale.subtract(new BigInteger(input.substring(expIndex + 1)));
        return new SigAndExp(unscaled, scale);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BiggerDecimal$() {
        MODULE$ = this;
        this.MaxBigIntegerDigits = BigInteger.valueOf(262144L);
        this.MaxInt = BigInteger.valueOf(Integer.MAX_VALUE);
        this.MinInt = BigInteger.valueOf(Integer.MIN_VALUE);
        this.MaxLong = new BigDecimal(Long.MAX_VALUE);
        this.MinLong = new BigDecimal(Long.MIN_VALUE);
        this.UnsignedZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return false;
            }

            public final double toDouble() {
                return 0.0;
            }

            public final float toFloat() {
                return 0.0f;
            }

            public final boolean equals(Object that) {
                Object object = that;
                if (object instanceof BiggerDecimal.Zero) {
                    BiggerDecimal.Zero zero = (BiggerDecimal.Zero)object;
                    return !zero.isNegativeZero();
                }
                return false;
            }

            public final int hashCode() {
                return Double.hashCode(0.0);
            }

            public final String toString() {
                return "0";
            }
        };
        this.NegativeZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return true;
            }

            public final double toDouble() {
                return -0.0;
            }

            public final float toFloat() {
                return -0.0f;
            }

            public final boolean equals(Object that) {
                Object object = that;
                if (object instanceof BiggerDecimal.Zero) {
                    BiggerDecimal.Zero zero = (BiggerDecimal.Zero)object;
                    return zero.isNegativeZero();
                }
                return false;
            }

            public final int hashCode() {
                return Double.hashCode(-0.0);
            }

            public final String toString() {
                return "-0";
            }
        };
    }
}

