/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ChunkLike;
import zio.Duration$;
import zio.internal.metrics.ConcurrentMetricHooks;
import zio.internal.metrics.MetricHook;
import zio.internal.metrics.package$;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricState;

@ScalaSignature(bytes="\u0006\u0001U3Qa\u0002\u0005\u0001\u00199AQ!\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQ\u0001\r\u0001\u0005\u0002EBQ!\u0010\u0001\u0005\u0002yBQ!\u0012\u0001\u0005\u0002\u0019CQ!\u0014\u0001\u0005\u00029\u0013QeQ8oGV\u0014(/\u001a8u\u001b\u0016$(/[2I_>\\7\u000f\u00157bi\u001a|'/\\*qK\u000eLg-[2\u000b\u0005%Q\u0011aB7fiJL7m\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002\u001b\u0005\u0019!0[8\u0014\u0007\u0001yQ\u0003\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-]i\u0011\u0001C\u0005\u00031!\u0011QcQ8oGV\u0014(/\u001a8u\u001b\u0016$(/[2I_>\\7/\u0001\u0004=S:LGOP\u0002\u0001)\u0005a\u0002C\u0001\f\u0001\u0003\u001d\u0019w.\u001e8uKJ$\"a\b\u0014\u0011\u0005\u0001\u001acB\u0001\f\"\u0013\t\u0011\u0003\"\u0001\u0006NKR\u0014\u0018n\u0019%p_.L!\u0001J\u0013\u0003\u000f\r{WO\u001c;fe*\u0011!\u0005\u0003\u0005\u0006O\t\u0001\r\u0001K\u0001\u0004W\u0016L\bCA\u0015/\u001d\tQC&D\u0001,\u0015\tIA\"\u0003\u0002.W\u0005IQ*\u001a;sS\u000e\\U-_\u0005\u0003I=R!!L\u0016\u0002\u000b\u001d\fWoZ3\u0015\u0007I*\u0004\b\u0005\u0002!g%\u0011A'\n\u0002\u0006\u000f\u0006,x-\u001a\u0005\u0006O\r\u0001\rA\u000e\t\u0003S]J!\u0001N\u0018\t\u000be\u001a\u0001\u0019\u0001\u001e\u0002\u000fM$\u0018M\u001d;BiB\u0011\u0001cO\u0005\u0003yE\u0011a\u0001R8vE2,\u0017!\u00035jgR|wM]1n)\ty$\t\u0005\u0002!\u0001&\u0011\u0011)\n\u0002\n\u0011&\u001cHo\\4sC6DQa\n\u0003A\u0002\r\u0003\"!\u000b#\n\u0005\u0005{\u0013aB:v[6\f'/\u001f\u000b\u0003\u000f*\u0003\"\u0001\t%\n\u0005%+#aB*v[6\f'/\u001f\u0005\u0006O\u0015\u0001\ra\u0013\t\u0003S1K!!S\u0018\u0002\u0013\u0019\u0014X-];f]\u000eLHCA(S!\t\u0001\u0003+\u0003\u0002RK\tIaI]3rk\u0016t7-\u001f\u0005\u0006O\u0019\u0001\ra\u0015\t\u0003SQK!!U\u0018")
public class ConcurrentMetricHooksPlatformSpecific
implements ConcurrentMetricHooks {
    @Override
    public MetricHook<Object, MetricState.Counter> counter(MetricKey<MetricKeyType$Counter$> key) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        return new MetricHook<Object, MetricState.Counter>((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> sum$1.elem += v, (Function0<MetricState.Counter>)(Function0 & Serializable & scala.Serializable)() -> new MetricState.Counter(sum$1.elem), (Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> sum$1.elem += v);
    }

    @Override
    public MetricHook<Object, MetricState.Gauge> gauge(MetricKey<MetricKeyType$Gauge$> key, double startAt) {
        DoubleRef value = DoubleRef.create((double)startAt);
        return new MetricHook<Object, MetricState.Gauge>((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            value$1.elem = v;
        }, (Function0<MetricState.Gauge>)(Function0 & Serializable & scala.Serializable)() -> new MetricState.Gauge(value$1.elem), (Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> value$1.elem += v);
    }

    @Override
    public MetricHook<Object, MetricState.Histogram> histogram(MetricKey<MetricKeyType.Histogram> key) {
        Chunk<Object> bounds = key.keyType().boundaries().values();
        long[] values = (long[])Array$.MODULE$.ofDim(bounds.length() + 1, ClassTag$.MODULE$.Long());
        double[] boundaries = (double[])Array$.MODULE$.ofDim(bounds.length(), ClassTag$.MODULE$.Double());
        LongRef count = LongRef.create((long)0L);
        DoubleRef sum = DoubleRef.create((double)0.0);
        IntRef size = IntRef.create((int)bounds.length());
        DoubleRef min = DoubleRef.create((double)Double.MAX_VALUE);
        DoubleRef max = DoubleRef.create((double)Double$.MODULE$.MinValue());
        ((Chunk)bounds.sorted((Ordering)Ordering.Double$.MODULE$)).zipWithIndex().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConcurrentMetricHooksPlatformSpecific.$anonfun$histogram$1(boundaries, x0$1);
            return BoxedUnit.UNIT;
        });
        JFunction1.mcVD.sp & Serializable & scala.Serializable update = (JFunction1.mcVD.sp & Serializable & scala.Serializable)value -> {
            int from = 0;
            int to = size$1.elem;
            while (from != to) {
                int mid = from + (to - from) / 2;
                double boundary = boundaries[mid];
                if (value <= boundary) {
                    to = mid;
                } else {
                    from = mid;
                }
                if (to != from + 1) continue;
                if (value <= boundaries[from]) {
                    to = from;
                    continue;
                }
                from = to;
            }
            values$1[from] = values[from] + 1L;
            ++count$1.elem;
            sum$2.elem += value;
            if (value < min$1.elem) {
                min$1.elem = value;
            }
            if (value > max$1.elem) {
                max$1.elem = value;
            }
        };
        return new MetricHook<Object, MetricState.Histogram>((Function1<Object, BoxedUnit>)update, (Function0<MetricState.Histogram>)(Function0 & Serializable & scala.Serializable)() -> new MetricState.Histogram(ConcurrentMetricHooksPlatformSpecific.getBuckets$1(size, boundaries, values), count$1.elem, min$1.elem, max$1.elem, sum$2.elem), (Function1<Object, BoxedUnit>)update);
    }

    @Override
    public MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary(MetricKey<MetricKeyType.Summary> key) {
        Tuple2[] values = (Tuple2[])Array$.MODULE$.ofDim(key.keyType().maxSize(), ClassTag$.MODULE$.apply(Tuple2.class));
        IntRef head = IntRef.create((int)0);
        LongRef count = LongRef.create((long)0L);
        DoubleRef sum = DoubleRef.create((double)0.0);
        DoubleRef min = DoubleRef.create((double)Double.MAX_VALUE);
        DoubleRef max = DoubleRef.create((double)Double$.MODULE$.MinValue());
        Object sortedQuantiles = key.keyType().quantiles().sorted((Ordering)package$.MODULE$.DoubleOrdering());
        return new MetricHook<Tuple2<Object, Instant>, MetricState.Summary>((Function1 & Serializable & scala.Serializable)t -> {
            ConcurrentMetricHooksPlatformSpecific.observe$1(t._1$mcD$sp(), (Instant)t._2(), key, head, values, count, sum, min, max);
            return BoxedUnit.UNIT;
        }, () -> ConcurrentMetricHooksPlatformSpecific.$anonfun$summary$3(key, values, (Chunk)sortedQuantiles, count, min, max, sum), (Function1 & Serializable & scala.Serializable)t -> {
            ConcurrentMetricHooksPlatformSpecific.observe$1(t._1$mcD$sp(), (Instant)t._2(), key, head, values, count, sum, min, max);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public MetricHook<String, MetricState.Frequency> frequency(MetricKey<MetricKeyType$Frequency$> key) {
        LongRef count = LongRef.create((long)0L);
        HashMap values = new HashMap();
        Function1 & Serializable & scala.Serializable update = (Function1 & Serializable & scala.Serializable)word -> {
            ConcurrentMetricHooksPlatformSpecific.$anonfun$frequency$1(count, values, word);
            return BoxedUnit.UNIT;
        };
        return new MetricHook<String, MetricState.Frequency>(update, (Function0 & Serializable & scala.Serializable)() -> new MetricState.Frequency((Map<String, Object>)ConcurrentMetricHooksPlatformSpecific.snapshot$2(values)), update);
    }

    public static final /* synthetic */ void $anonfun$histogram$1(double[] boundaries$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            double n = x0$1._1$mcD$sp();
            int i = x0$1._2$mcI$sp();
            boundaries$1[i] = n;
            return;
        }
        throw new MatchError(null);
    }

    private static final Chunk getBuckets$1(IntRef size$1, double[] boundaries$1, long[] values$1) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        long cumulated = 0L;
        for (int i = 0; i != size$1.elem; ++i) {
            double boundary = boundaries$1[i];
            long value = values$1[i];
            builder.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)boundary)), (Object)BoxesRunTime.boxToLong((long)(cumulated += value))));
        }
        return (Chunk)builder.result();
    }

    private static final long getCount$1(LongRef count$2) {
        return count$2.elem;
    }

    private static final double getMin$1(DoubleRef min$2) {
        return min$2.elem;
    }

    private static final double getMax$1(DoubleRef max$2) {
        return max$2.elem;
    }

    private static final double getSum$1(DoubleRef sum$3) {
        return sum$3.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$summary$1(Tuple2[] values$2, Instant now$1, MetricKey key$1, ChunkBuilder builder$1, int idx) {
        Tuple2 item = values$2[idx];
        if (item != null) {
            void var6_6;
            Instant t = (Instant)item._1();
            double d = item._2$mcD$sp();
            Duration age = Duration$.MODULE$.fromInterval((Instant)var6_6, now$1);
            if (!age.isNegative() && age.compareTo(((MetricKeyType.Summary)key$1.keyType()).maxAge()) <= 0) {
                return builder$1.$plus$eq(BoxesRunTime.boxToDouble((double)d));
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    private static final Chunk snapshot$1(Instant now, MetricKey key$1, Tuple2[] values$2, Chunk sortedQuantiles$1) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((MetricKeyType.Summary)key$1.keyType()).maxSize()).foreach((Function1 & Serializable & scala.Serializable)idx -> ConcurrentMetricHooksPlatformSpecific.$anonfun$summary$1(values$2, now, key$1, builder, BoxesRunTime.unboxToInt((Object)idx)));
        return package$.MODULE$.calculateQuantiles(sortedQuantiles$1, ((ChunkLike)builder.result()).sorted(package$.MODULE$.DoubleOrdering()));
    }

    private static final void observe$1(double value, Instant t, MetricKey key$1, IntRef head$1, Tuple2[] values$2, LongRef count$2, DoubleRef sum$3, DoubleRef min$2, DoubleRef max$2) {
        if (((MetricKeyType.Summary)key$1.keyType()).maxSize() > 0) {
            ++head$1.elem;
            int target = head$1.elem % ((MetricKeyType.Summary)key$1.keyType()).maxSize();
            values$2[target] = new Tuple2((Object)t, (Object)BoxesRunTime.boxToDouble((double)value));
        }
        ++count$2.elem;
        sum$3.elem += value;
        if (value < min$2.elem) {
            min$2.elem = value;
        }
        if (value > max$2.elem) {
            max$2.elem = value;
        }
    }

    public static final /* synthetic */ MetricState.Summary $anonfun$summary$3(MetricKey key$1, Tuple2[] values$2, Chunk sortedQuantiles$1, LongRef count$2, DoubleRef min$2, DoubleRef max$2, DoubleRef sum$3) {
        return new MetricState.Summary(((MetricKeyType.Summary)key$1.keyType()).error(), ConcurrentMetricHooksPlatformSpecific.snapshot$1(Instant.now(), key$1, values$2, sortedQuantiles$1), ConcurrentMetricHooksPlatformSpecific.getCount$1(count$2), ConcurrentMetricHooksPlatformSpecific.getMin$1(min$2), ConcurrentMetricHooksPlatformSpecific.getMax$1(max$2), ConcurrentMetricHooksPlatformSpecific.getSum$1(sum$3));
    }

    public static final /* synthetic */ void $anonfun$frequency$1(LongRef count$3, HashMap values$3, String word) {
        ++count$3.elem;
        long slotCount = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(values$3.get(word)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        values$3.put(word, BoxesRunTime.boxToLong((long)(slotCount + 1L)));
    }

    private static final Map snapshot$2(HashMap values$3) {
        scala.collection.mutable.Map builder = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (Map.Entry e : values$3.entrySet()) {
            builder.update(e.getKey(), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong(e.getValue())));
        }
        return builder.toMap(Predef$.MODULE$.$conforms());
    }
}

