/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.util.Arrays;
import zio.json.internal.OneCharReader;
import zio.json.internal.PlaybackReader;
import zio.json.internal.RecordingReader;
import zio.json.internal.RetractReader;
import zio.json.internal.RewindTwice;

public final class WithRecordingReader
extends Reader
implements OneCharReader,
RecordingReader,
PlaybackReader {
    private final OneCharReader in;
    private int state;
    private char[] tape;
    private int reading;
    private int writing;

    public WithRecordingReader(OneCharReader in, int initial) {
        this.in = in;
        this.state = 0;
        this.tape = new char[Math.max(initial, 1)];
        this.reading = 0;
        this.writing = 0;
    }

    @Override
    public void close() {
        ((Reader)((Object)this.in)).close();
    }

    @Override
    public int read() {
        int c;
        if (this.state < 0) {
            return this.in.read();
        }
        if (this.state > 0) {
            int reading = this.reading;
            char c2 = this.tape[reading];
            this.reading = ++reading;
            if (reading == this.writing) {
                this.state = -1;
            }
            return c2;
        }
        int writing = this.writing;
        if (writing == this.tape.length) {
            this.tape = Arrays.copyOf(this.tape, writing << 1);
        }
        if ((c = this.in.read()) >= 0) {
            this.tape[writing] = (char)c;
            this.writing = writing + 1;
        }
        return c;
    }

    @Override
    public char readChar() {
        char c;
        if (this.state < 0) {
            return this.in.readChar();
        }
        if (this.state > 0) {
            int reading = this.reading;
            char c2 = this.tape[reading];
            this.reading = ++reading;
            if (reading == this.writing) {
                this.state = -1;
            }
            return c2;
        }
        int writing = this.writing;
        if (writing == this.tape.length) {
            this.tape = Arrays.copyOf(this.tape, writing << 1);
        }
        this.tape[writing] = c = this.in.readChar();
        this.writing = writing + 1;
        return c;
    }

    @Override
    public void rewind() {
        if (this.state == 0) {
            this.state = 1;
            return;
        }
        throw new RewindTwice();
    }

    @Override
    public void retract() {
        if (this.state > 0) {
            --this.reading;
            return;
        }
        OneCharReader oneCharReader = this.in;
        if (oneCharReader instanceof RetractReader) {
            RetractReader rr = (RetractReader)oneCharReader;
            rr.retract();
            if (this.state == 0) {
                --this.writing;
                return;
            }
            return;
        }
        throw new UnsupportedOperationException("underlying reader does not support retract");
    }

    @Override
    public int offset() {
        if (this.state > 0) {
            return this.reading;
        }
        return this.writing;
    }

    @Override
    public char history(int idx) {
        return this.tape[idx];
    }
}

