/*
 * Decompiled with CFR 0.152.
 */
package zio.json;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Chunk;
import zio.Chunk$;
import zio.json.EncoderLowPriority1;
import zio.json.EncoderLowPriority2;
import zio.json.EncoderLowPriority3;
import zio.json.EncoderLowPriority4;
import zio.json.GeneratedTupleEncoders;
import zio.json.JsonEncoder;
import zio.json.JsonEncoderVersionSpecific;
import zio.json.ast.Json;
import zio.json.ast.Json$Bool$;
import zio.json.ast.Json$Null$;
import zio.json.ast.Json$Num$;
import zio.json.ast.Json$Obj$;
import zio.json.internal.SafeNumbers$;
import zio.json.internal.Write;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JsonEncoder$
implements GeneratedTupleEncoders,
EncoderLowPriority4,
EncoderLowPriority3,
EncoderLowPriority2,
EncoderLowPriority1,
JsonEncoderVersionSpecific,
Serializable {
    private static JsonEncoder dayOfWeek;
    private static JsonEncoder duration;
    private static JsonEncoder instant;
    private static JsonEncoder localDate;
    private static JsonEncoder localDateTime;
    private static JsonEncoder localTime;
    private static JsonEncoder month;
    private static JsonEncoder monthDay;
    private static JsonEncoder offsetDateTime;
    private static JsonEncoder offsetTime;
    private static JsonEncoder period;
    private static JsonEncoder year;
    private static JsonEncoder yearMonth;
    private static JsonEncoder zonedDateTime;
    private static JsonEncoder zoneId;
    private static JsonEncoder zoneOffset;
    private static JsonEncoder uuid;
    private static JsonEncoder currency;
    public static final ThreadLocal<JsonEncoder.FastStringWritePool> zio$json$JsonEncoder$$$writePools;
    private static final JsonEncoder string;
    private static final JsonEncoder char;
    private static final JsonEncoder boolean;
    private static final JsonEncoder symbol;
    private static final JsonEncoder byte;
    private static final JsonEncoder short;
    private static final JsonEncoder int;
    private static final JsonEncoder long;
    private static final JsonEncoder bigInteger;
    private static final JsonEncoder scalaBigInt;
    private static final JsonEncoder double;
    private static final JsonEncoder float;
    private static final JsonEncoder bigDecimal;
    private static final JsonEncoder scalaBigDecimal;
    public static final JsonEncoder$ MODULE$;

    private JsonEncoder$() {
    }

    static {
        MODULE$ = new JsonEncoder$();
        EncoderLowPriority3.$init$(MODULE$);
        zio$json$JsonEncoder$$$writePools = new ThreadLocal<JsonEncoder.FastStringWritePool>(){

            public JsonEncoder.FastStringWritePool initialValue() {
                return new JsonEncoder.FastStringWritePool();
            }
        };
        string = new JsonEncoder<String>(){

            public void unsafeEncode(String a, Option indent, Write out) {
                out.write('\"');
                int len = a.length();
                for (int i = 0; i < len; ++i) {
                    char c = a.charAt(i);
                    if (c != '\"' && c != '\\' && c >= ' ') continue;
                    this.writeEncoded(a, out);
                    return;
                }
                out.write(a);
                out.write('\"');
            }

            public Either toJsonAST(String a) {
                return new Right((Object)new Json.Str(a));
            }

            private void writeEncoded(String a, Write out) {
                int len = a.length();
                block9: for (int i = 0; i < len; ++i) {
                    char c = a.charAt(i);
                    switch (c) {
                        case '\"': {
                            out.write('\\', '\"');
                            continue block9;
                        }
                        case '\\': {
                            out.write('\\', '\\');
                            continue block9;
                        }
                        case '\b': {
                            out.write('\\', 'b');
                            continue block9;
                        }
                        case '\f': {
                            out.write('\\', 'f');
                            continue block9;
                        }
                        case '\n': {
                            out.write('\\', 'n');
                            continue block9;
                        }
                        case '\r': {
                            out.write('\\', 'r');
                            continue block9;
                        }
                        case '\t': {
                            out.write('\\', 't');
                            continue block9;
                        }
                        default: {
                            char c2 = c;
                            if (c2 >= ' ') {
                                out.write(c2);
                                continue block9;
                            }
                            out.write('\\', 'u');
                            SafeNumbers$.MODULE$.writeHex(c2, out);
                            continue block9;
                        }
                    }
                }
                out.write('\"');
            }
        };
        char = new JsonEncoder<Object>(){

            public void unsafeEncode(char a, Option indent, Write out) {
                char c = a;
                switch (c) {
                    case '\"': {
                        out.write('\"', '\\', '\"', '\"');
                        return;
                    }
                    case '\\': {
                        out.write('\"', '\\', '\\', '\"');
                        return;
                    }
                    case '\b': {
                        out.write('\"', '\\', 'b', '\"');
                        return;
                    }
                    case '\f': {
                        out.write('\"', '\\', 'f', '\"');
                        return;
                    }
                    case '\n': {
                        out.write('\"', '\\', 'n', '\"');
                        return;
                    }
                    case '\r': {
                        out.write('\"', '\\', 'r', '\"');
                        return;
                    }
                    case '\t': {
                        out.write('\"', '\\', 't', '\"');
                        return;
                    }
                }
                char c2 = c;
                if (c2 >= ' ') {
                    out.write('\"', c2, '\"');
                    return;
                }
                out.write('\"', '\\', 'u');
                SafeNumbers$.MODULE$.writeHex(c2, out);
                out.write('\"');
            }

            public Either toJsonAST(char a) {
                return new Right((Object)new Json.Str(BoxesRunTime.boxToCharacter((char)a).toString()));
            }
        };
        boolean = new JsonEncoder<Object>(){

            public void unsafeEncode(boolean a, Option indent, Write out) {
                if (a) {
                    out.write('t', 'r', 'u', 'e');
                    return;
                }
                out.write('f', 'a', 'l', 's', 'e');
            }

            public Either toJsonAST(boolean a) {
                return new Right((Object)Json$Bool$.MODULE$.apply(a));
            }
        };
        symbol = MODULE$.string().contramap((Function1 & Serializable)_$1 -> _$1.name());
        byte = new JsonEncoder<Object>(){

            public void unsafeEncode(byte a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(byte a) {
                return new Right((Object)Json$Num$.MODULE$.apply((int)a));
            }
        };
        short = new JsonEncoder<Object>(){

            public void unsafeEncode(short a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(short a) {
                return new Right((Object)Json$Num$.MODULE$.apply((int)a));
            }
        };
        int = new JsonEncoder<Object>(){

            public void unsafeEncode(int a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(int a) {
                return new Right((Object)Json$Num$.MODULE$.apply(a));
            }
        };
        long = new JsonEncoder<Object>(){

            public void unsafeEncode(long a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(long a) {
                return new Right((Object)Json$Num$.MODULE$.apply(a));
            }
        };
        bigInteger = new JsonEncoder<BigInteger>(){

            public void unsafeEncode(BigInteger a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(BigInteger a) {
                return new Right((Object)Json$Num$.MODULE$.apply(a));
            }
        };
        scalaBigInt = new JsonEncoder<BigInt>(){

            public void unsafeEncode(BigInt a, Option indent, Write out) {
                if (a.isValidLong()) {
                    SafeNumbers$.MODULE$.write(a.longValue(), out);
                    return;
                }
                SafeNumbers$.MODULE$.write(a.bigInteger(), out);
            }

            public Either toJsonAST(BigInt a) {
                return new Right((Object)Json$Num$.MODULE$.apply(a));
            }
        };
        double = new JsonEncoder<Object>(){

            public void unsafeEncode(double a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(double a) {
                return new Right((Object)Json$Num$.MODULE$.apply(a));
            }
        };
        float = new JsonEncoder<Object>(){

            public void unsafeEncode(float a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(float a) {
                return new Right((Object)Json$Num$.MODULE$.apply(a));
            }
        };
        bigDecimal = new JsonEncoder<java.math.BigDecimal>(){

            public void unsafeEncode(java.math.BigDecimal a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a, out);
            }

            public Either toJsonAST(java.math.BigDecimal a) {
                return new Right((Object)new Json.Num(a));
            }
        };
        scalaBigDecimal = new JsonEncoder<BigDecimal>(){

            public void unsafeEncode(BigDecimal a, Option indent, Write out) {
                SafeNumbers$.MODULE$.write(a.bigDecimal(), out);
            }

            public Either toJsonAST(BigDecimal a) {
                return new Right((Object)new Json.Num(a.bigDecimal()));
            }
        };
        Statics.releaseFence();
    }

    public JsonEncoder dayOfWeek() {
        return dayOfWeek;
    }

    public JsonEncoder duration() {
        return duration;
    }

    public JsonEncoder instant() {
        return instant;
    }

    public JsonEncoder localDate() {
        return localDate;
    }

    public JsonEncoder localDateTime() {
        return localDateTime;
    }

    public JsonEncoder localTime() {
        return localTime;
    }

    public JsonEncoder month() {
        return month;
    }

    public JsonEncoder monthDay() {
        return monthDay;
    }

    public JsonEncoder offsetDateTime() {
        return offsetDateTime;
    }

    public JsonEncoder offsetTime() {
        return offsetTime;
    }

    public JsonEncoder period() {
        return period;
    }

    public JsonEncoder year() {
        return year;
    }

    public JsonEncoder yearMonth() {
        return yearMonth;
    }

    public JsonEncoder zonedDateTime() {
        return zonedDateTime;
    }

    public JsonEncoder zoneId() {
        return zoneId;
    }

    public JsonEncoder zoneOffset() {
        return zoneOffset;
    }

    public JsonEncoder uuid() {
        return uuid;
    }

    public JsonEncoder currency() {
        return currency;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$dayOfWeek_$eq(JsonEncoder x$0) {
        dayOfWeek = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$duration_$eq(JsonEncoder x$0) {
        duration = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$instant_$eq(JsonEncoder x$0) {
        instant = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$localDate_$eq(JsonEncoder x$0) {
        localDate = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$localDateTime_$eq(JsonEncoder x$0) {
        localDateTime = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$localTime_$eq(JsonEncoder x$0) {
        localTime = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$month_$eq(JsonEncoder x$0) {
        month = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$monthDay_$eq(JsonEncoder x$0) {
        monthDay = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$offsetDateTime_$eq(JsonEncoder x$0) {
        offsetDateTime = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$offsetTime_$eq(JsonEncoder x$0) {
        offsetTime = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$period_$eq(JsonEncoder x$0) {
        period = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$year_$eq(JsonEncoder x$0) {
        year = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$yearMonth_$eq(JsonEncoder x$0) {
        yearMonth = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$zonedDateTime_$eq(JsonEncoder x$0) {
        zonedDateTime = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$zoneId_$eq(JsonEncoder x$0) {
        zoneId = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$zoneOffset_$eq(JsonEncoder x$0) {
        zoneOffset = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$uuid_$eq(JsonEncoder x$0) {
        uuid = x$0;
    }

    @Override
    public void zio$json$EncoderLowPriority3$_setter_$currency_$eq(JsonEncoder x$0) {
        currency = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonEncoder$.class);
    }

    public <A> JsonEncoder<A> apply(JsonEncoder<A> a) {
        return a;
    }

    public JsonEncoder<String> string() {
        return string;
    }

    public JsonEncoder<Object> char() {
        return char;
    }

    public <A> JsonEncoder<A> explicit(Function1<A, String> f, Function1<A, Json> g) {
        return new JsonEncoder<A>(f, g){
            private final Function1 f$2;
            private final Function1 g$1;
            {
                this.f$2 = f$5;
                this.g$1 = g$2;
            }

            public void unsafeEncode(Object a, Option indent, Write out) {
                out.write((String)this.f$2.apply(a));
            }

            public Either toJsonAST(Object a) {
                return new Right(this.g$1.apply(a));
            }
        };
    }

    public <A> JsonEncoder<A> stringify(Function1<A, String> f) {
        return new JsonEncoder<A>(f){
            private final Function1 f$3;
            {
                this.f$3 = f$6;
            }

            public void unsafeEncode(Object a, Option indent, Write out) {
                out.write('\"');
                out.write((String)this.f$3.apply(a));
                out.write('\"');
            }

            public Either toJsonAST(Object a) {
                return new Right((Object)new Json.Str((String)this.f$3.apply(a)));
            }
        };
    }

    public <A> JsonEncoder<A> suspend(Function0<JsonEncoder<A>> encoder0) {
        return new JsonEncoder<A>(encoder0){
            private final Function0 encoder0$1;
            private JsonEncoder encoder$lzy1;
            private boolean encoderbitmap$1;
            {
                this.encoder0$1 = encoder0$2;
            }

            public JsonEncoder encoder() {
                if (!this.encoderbitmap$1) {
                    this.encoder$lzy1 = (JsonEncoder)this.encoder0$1.apply();
                    this.encoderbitmap$1 = true;
                }
                return this.encoder$lzy1;
            }

            public void unsafeEncode(Object a, Option indent, Write out) {
                this.encoder().unsafeEncode(a, (Option<Object>)indent, out);
            }

            public boolean isNothing(Object a) {
                return this.encoder().isNothing(a);
            }

            public boolean isEmpty(Object a) {
                return this.encoder().isEmpty(a);
            }

            public Either toJsonAST(Object a) {
                return this.encoder().toJsonAST(a);
            }
        };
    }

    public JsonEncoder<Object> boolean() {
        return boolean;
    }

    public JsonEncoder<Symbol> symbol() {
        return symbol;
    }

    public JsonEncoder<Object> byte() {
        return byte;
    }

    public JsonEncoder<Object> short() {
        return short;
    }

    public JsonEncoder<Object> int() {
        return int;
    }

    public JsonEncoder<Object> long() {
        return long;
    }

    public JsonEncoder<BigInteger> bigInteger() {
        return bigInteger;
    }

    public JsonEncoder<BigInt> scalaBigInt() {
        return scalaBigInt;
    }

    public JsonEncoder<Object> double() {
        return double;
    }

    public JsonEncoder<Object> float() {
        return float;
    }

    public JsonEncoder<java.math.BigDecimal> bigDecimal() {
        return bigDecimal;
    }

    public JsonEncoder<BigDecimal> scalaBigDecimal() {
        return scalaBigDecimal;
    }

    public <A> JsonEncoder<Option<A>> option(JsonEncoder<A> A) {
        return new JsonEncoder<Option<A>>(A){
            private final JsonEncoder A$1;
            {
                this.A$1 = A$8;
            }

            public void unsafeEncode(Option oa, Option indent, Write out) {
                if (oa == None$.MODULE$) {
                    out.write('n', 'u', 'l', 'l');
                    return;
                }
                this.A$1.unsafeEncode(oa.get(), (Option<Object>)indent, out);
            }

            public boolean isNothing(Option oa) {
                return oa == None$.MODULE$ || this.A$1.isNothing(oa.get());
            }

            public Either toJsonAST(Option oa) {
                if (oa == None$.MODULE$) {
                    return new Right((Object)Json$Null$.MODULE$);
                }
                return this.A$1.toJsonAST(oa.get());
            }
        };
    }

    public Option<Object> bump(Option<Object> indent) {
        if (indent != None$.MODULE$) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)indent.get()) + 1)));
        }
        return indent;
    }

    public void pad(Option<Object> indent, Write out) {
        if (indent != None$.MODULE$) {
            int i;
            out.write('\n');
            short ws = 8224;
            for (i = BoxesRunTime.unboxToInt((Object)indent.get()); i > 4; i -= 4) {
                out.write(ws, ws, ws, ws);
            }
            while (i > 0) {
                out.write(ws);
                --i;
            }
            return;
        }
    }

    public <A, B> JsonEncoder<Either<A, B>> either(JsonEncoder<A> A, JsonEncoder<B> B) {
        return new JsonEncoder<Either<A, B>>(A, B){
            private final JsonEncoder A$2;
            private final JsonEncoder B$1;
            {
                this.A$2 = A$9;
                this.B$1 = B$3;
            }

            public void unsafeEncode(Either eab, Option indent, Write out) {
                out.write('{');
                if (indent.isDefined()) {
                    this.unsafeEncodePadded(eab, indent, out);
                } else {
                    this.unsafeEncodeCompact(eab, indent, out);
                }
                out.write('}');
            }

            private void unsafeEncodeCompact(Either eab, Option indent, Write out) {
                Either either = eab;
                if (either instanceof Left) {
                    Object a = ((Left)either).value();
                    out.write("\"Left\":");
                    this.A$2.unsafeEncode(a, (Option<Object>)indent, out);
                    return;
                }
                if (either instanceof Right) {
                    Object b = ((Right)either).value();
                    out.write("\"Right\":");
                    this.B$1.unsafeEncode(b, (Option<Object>)indent, out);
                    return;
                }
                throw new MatchError((Object)either);
            }

            private void unsafeEncodePadded(Either eab, Option indent, Write out) {
                Option<Object> indent_ = JsonEncoder$.MODULE$.bump((Option<Object>)indent);
                JsonEncoder$.MODULE$.pad(indent_, out);
                Either either = eab;
                if (either instanceof Left) {
                    Object a = ((Left)either).value();
                    out.write("\"Left\" : ");
                    this.A$2.unsafeEncode(a, indent_, out);
                } else if (either instanceof Right) {
                    Object b = ((Right)either).value();
                    out.write("\"Right\" : ");
                    this.B$1.unsafeEncode(b, indent_, out);
                } else {
                    throw new MatchError((Object)either);
                }
                JsonEncoder$.MODULE$.pad((Option<Object>)indent, out);
            }

            public Either toJsonAST(Either eab) {
                Either either = eab;
                if (either instanceof Left) {
                    Object a = ((Left)either).value();
                    return this.A$2.toJsonAST(a).map(JsonEncoder$::zio$json$JsonEncoder$$anon$20$$_$toJsonAST$$anonfun$1);
                }
                if (either instanceof Right) {
                    Object b = ((Right)either).value();
                    return this.B$1.toJsonAST(b).map(JsonEncoder$::zio$json$JsonEncoder$$anon$20$$_$toJsonAST$$anonfun$2);
                }
                throw new MatchError((Object)either);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$json$JsonEncoder$$anon$20$$_$toJsonAST$$anonfun$1(zio.json.ast.Json ), zio$json$JsonEncoder$$anon$20$$_$toJsonAST$$anonfun$2(zio.json.ast.Json )}, serializedLambda);
            }
        };
    }

    public <A, B> JsonEncoder<Either<A, B>> orElseEither(JsonEncoder<A> A, JsonEncoder<B> B) {
        return new JsonEncoder<Either<A, B>>(A, B){
            private final JsonEncoder A$3;
            private final JsonEncoder B$2;
            {
                this.A$3 = A$10;
                this.B$2 = B$4;
            }

            public void unsafeEncode(Either eab, Option indent, Write out) {
                Either either = eab;
                if (either instanceof Left) {
                    Object a = ((Left)either).value();
                    this.A$3.unsafeEncode(a, (Option<Object>)indent, out);
                    return;
                }
                if (either instanceof Right) {
                    Object b = ((Right)either).value();
                    this.B$2.unsafeEncode(b, (Option<Object>)indent, out);
                    return;
                }
                throw new MatchError((Object)either);
            }
        };
    }

    public static final /* synthetic */ Json.Obj zio$json$JsonEncoder$$anon$20$$_$toJsonAST$$anonfun$1(Json v) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Left");
        return Json$Obj$.MODULE$.apply((Chunk<Tuple2<String, Json>>)Chunk$.MODULE$.single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v)));
    }

    public static final /* synthetic */ Json.Obj zio$json$JsonEncoder$$anon$20$$_$toJsonAST$$anonfun$2(Json v) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Right");
        return Json$Obj$.MODULE$.apply((Chunk<Tuple2<String, Json>>)Chunk$.MODULE$.single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v)));
    }
}

