/*
 * Decompiled with CFR 0.152.
 */
package zio.json.javatime;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.runtime.ModuleSerializationProxy;
import zio.json.internal.FastStringWrite;
import zio.json.internal.SafeNumbers$;
import zio.json.internal.Write;

public final class serializers$
implements Serializable {
    private static final ThreadLocal<FastStringWrite> writes;
    public static final serializers$ MODULE$;

    private serializers$() {
    }

    static {
        MODULE$ = new serializers$();
        writes = new ThreadLocal<FastStringWrite>(){

            public FastStringWrite initialValue() {
                return new FastStringWrite(64);
            }

            public FastStringWrite get() {
                FastStringWrite w = (FastStringWrite)super.get();
                w.reset();
                return w;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(serializers$.class);
    }

    public String toString(Duration x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(Duration x, Write out) {
        out.write('P', 'T');
        long totalSecs = x.getSeconds();
        int nano = x.getNano();
        if ((totalSecs | (long)nano) == 0L) {
            out.write('0', 'S');
            return;
        }
        long effectiveTotalSecs = totalSecs;
        if (totalSecs < 0L && nano > 0) {
            ++effectiveTotalSecs;
        }
        long hours = effectiveTotalSecs / 3600L;
        int secsOfHour = (int)(effectiveTotalSecs - hours * 3600L);
        int minutes = secsOfHour / 60;
        int seconds = secsOfHour - minutes * 60;
        if (hours != 0L) {
            SafeNumbers$.MODULE$.write(hours, out);
            out.write('H');
        }
        if (minutes != 0) {
            SafeNumbers$.MODULE$.write(minutes, out);
            out.write('M');
        }
        if ((seconds | nano) != 0) {
            if (totalSecs < 0L && seconds == 0) {
                out.write('-', '0');
            } else {
                SafeNumbers$.MODULE$.write(seconds, out);
            }
            if (nano != 0) {
                if (totalSecs < 0L) {
                    nano = 1000000000 - nano;
                }
                SafeNumbers$.MODULE$.writeNano(nano, out);
            }
            out.write('S');
            return;
        }
    }

    public String toString(Instant x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(Instant x, Write out) {
        int year;
        int marchDayOfYear;
        long epochSecond = x.getEpochSecond();
        long epochDay = (epochSecond >= 0L ? epochSecond : epochSecond - 86399L) / 86400L;
        int secsOfDay = (int)(epochSecond - epochDay * 86400L);
        long marchZeroDay = epochDay + 719468L;
        int adjustYear = 0;
        if (marchZeroDay < 0L) {
            int adjust400YearCycles = this.to400YearCycle(marchZeroDay + 1L) - 1;
            adjustYear = adjust400YearCycles * 400;
            marchZeroDay -= (long)adjust400YearCycles * 146097L;
        }
        if ((marchDayOfYear = this.toMarchDayOfYear(marchZeroDay, year = this.to400YearCycle(marchZeroDay * 400L + 591L))) < 0) {
            marchDayOfYear = this.toMarchDayOfYear(marchZeroDay, --year);
        }
        int marchMonth = marchDayOfYear * 17135 + 6854 >> 19;
        year += (marchMonth * 3277 >> 15) + adjustYear;
        int month = marchMonth + (marchMonth < 10 ? 3 : -9);
        int day = marchDayOfYear - (marchMonth * 1002762 - 16383 >> 15);
        int hour = secsOfDay * 37283 >>> 27;
        int secsOfHour = secsOfDay - hour * 3600;
        int minute = secsOfHour * 17477 >> 20;
        int second = secsOfHour - minute * 60;
        this.writeYear(year, out);
        out.write('-');
        SafeNumbers$.MODULE$.write2Digits(month, out);
        out.write('-');
        SafeNumbers$.MODULE$.write2Digits(day, out);
        out.write('T');
        SafeNumbers$.MODULE$.write2Digits(hour, out);
        out.write(':');
        SafeNumbers$.MODULE$.write2Digits(minute, out);
        out.write(':');
        SafeNumbers$.MODULE$.write2Digits(second, out);
        int nano = x.getNano();
        if (nano != 0) {
            out.write('.');
            int q1 = nano / 1000000;
            int r1 = nano - q1 * 1000000;
            SafeNumbers$.MODULE$.write3Digits(q1, out);
            if (r1 != 0) {
                int q2 = r1 / 1000;
                int r2 = r1 - q2 * 1000;
                SafeNumbers$.MODULE$.write3Digits(q2, out);
                if (r2 != 0) {
                    SafeNumbers$.MODULE$.write3Digits(r2, out);
                }
            }
        }
        out.write('Z');
    }

    public String toString(LocalDate x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(LocalDate x, Write out) {
        this.writeYear(x.getYear(), out);
        out.write('-');
        SafeNumbers$.MODULE$.write2Digits(x.getMonthValue(), out);
        out.write('-');
        SafeNumbers$.MODULE$.write2Digits(x.getDayOfMonth(), out);
    }

    public String toString(LocalDateTime x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(LocalDateTime x, Write out) {
        this.write(x.toLocalDate(), out);
        out.write('T');
        this.write(x.toLocalTime(), out);
    }

    public String toString(LocalTime x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(LocalTime x, Write out) {
        SafeNumbers$.MODULE$.write2Digits(x.getHour(), out);
        out.write(':');
        SafeNumbers$.MODULE$.write2Digits(x.getMinute(), out);
        out.write(':');
        SafeNumbers$.MODULE$.write2Digits(x.getSecond(), out);
        int nano = x.getNano();
        if (nano != 0) {
            SafeNumbers$.MODULE$.writeNano(nano, out);
            return;
        }
    }

    public String toString(MonthDay x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(MonthDay x, Write out) {
        out.write('-', '-');
        SafeNumbers$.MODULE$.write2Digits(x.getMonthValue(), out);
        out.write('-');
        SafeNumbers$.MODULE$.write2Digits(x.getDayOfMonth(), out);
    }

    public String toString(OffsetDateTime x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(OffsetDateTime x, Write out) {
        this.write(x.toLocalDate(), out);
        out.write('T');
        this.write(x.toLocalTime(), out);
        this.write(x.getOffset(), out);
    }

    public String toString(OffsetTime x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(OffsetTime x, Write out) {
        this.write(x.toLocalTime(), out);
        this.write(x.getOffset(), out);
    }

    public String toString(Period x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(Period x, Write out) {
        out.write('P');
        if (x.isZero()) {
            out.write('0', 'D');
            return;
        }
        int years = x.getYears();
        int months = x.getMonths();
        int days = x.getDays();
        if (years != 0) {
            SafeNumbers$.MODULE$.write(years, out);
            out.write('Y');
        }
        if (months != 0) {
            SafeNumbers$.MODULE$.write(months, out);
            out.write('M');
        }
        if (days != 0) {
            SafeNumbers$.MODULE$.write(days, out);
            out.write('D');
            return;
        }
    }

    public String toString(Year x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(Year x, Write out) {
        this.writeYear(x.getValue(), out);
    }

    public String toString(YearMonth x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(YearMonth x, Write out) {
        this.writeYear(x.getYear(), out);
        out.write('-');
        SafeNumbers$.MODULE$.write2Digits(x.getMonthValue(), out);
    }

    public String toString(ZonedDateTime x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(ZonedDateTime x, Write out) {
        this.write(x.toLocalDate(), out);
        out.write('T');
        this.write(x.toLocalTime(), out);
        this.write(x.getOffset(), out);
        ZoneId zone = x.getZone();
        if (!(zone instanceof ZoneOffset)) {
            out.write('[');
            out.write(zone.getId());
            out.write(']');
            return;
        }
    }

    public String toString(ZoneId x) {
        return x.getId();
    }

    public void write(ZoneId x, Write out) {
        out.write(x.getId());
    }

    public String toString(ZoneOffset x) {
        FastStringWrite out = writes.get();
        this.write(x, (Write)out);
        return out.toString();
    }

    public void write(ZoneOffset x, Write out) {
        int n;
        int totalSeconds = x.getTotalSeconds();
        if (totalSeconds == 0) {
            out.write('Z');
            return;
        }
        if (totalSeconds > 0) {
            out.write('+');
            n = totalSeconds;
        } else {
            out.write('-');
            n = -totalSeconds;
        }
        int q0 = n;
        int q1 = q0 * 37283 >>> 27;
        int r1 = q0 - q1 * 3600;
        SafeNumbers$.MODULE$.write2Digits(q1, out);
        out.write(':');
        int q2 = r1 * 17477 >> 20;
        int r2 = r1 - q2 * 60;
        SafeNumbers$.MODULE$.write2Digits(q2, out);
        if (r2 != 0) {
            out.write(':');
            SafeNumbers$.MODULE$.write2Digits(r2, out);
            return;
        }
    }

    private void writeYear(int x, Write out) {
        if (x >= 0) {
            if (x < 10000) {
                SafeNumbers$.MODULE$.write4Digits(x, out);
                return;
            }
            out.write('+');
            SafeNumbers$.MODULE$.write(x, out);
            return;
        }
        if (x > -10000) {
            out.write('-');
            SafeNumbers$.MODULE$.write4Digits(-x, out);
            return;
        }
        SafeNumbers$.MODULE$.write(x, out);
    }

    private int to400YearCycle(long day) {
        return (int)(day / 146097L);
    }

    private int toMarchDayOfYear(long marchZeroDay, int year) {
        int century = year / 100;
        return (int)(marchZeroDay - (long)year * 365L) - (year >> 2) + century - (century >> 2);
    }
}

