/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import zio.json.internal.OneCharReader;
import zio.json.internal.PlaybackReader;
import zio.json.internal.RetractReader;
import zio.json.internal.UnexpectedEnd;

public final class FastStringReader
extends Reader
implements OneCharReader,
RetractReader,
PlaybackReader {
    private final CharSequence s;
    private int i;
    private final int len;

    public FastStringReader(CharSequence s) {
        this.s = s;
        this.i = 0;
        this.len = s.length();
    }

    @Override
    public int offset() {
        return this.i;
    }

    @Override
    public void close() {
    }

    @Override
    public int read() {
        int i = this.i;
        if (i < this.len) {
            this.i = i + 1;
            return this.s.charAt(i);
        }
        return -1;
    }

    @Override
    public char readChar() {
        int i = this.i;
        if (i < this.len) {
            this.i = i + 1;
            return this.s.charAt(i);
        }
        throw new UnexpectedEnd();
    }

    @Override
    public char nextNonWhitespace() {
        int i;
        for (i = this.i; i < this.len; ++i) {
            char c = this.s.charAt(i);
            if (c == ' ' || c == '\n' || (c | 4) == 13) continue;
            this.i = i;
            return c;
        }
        this.i = i;
        throw new UnexpectedEnd();
    }

    @Override
    public void retract() {
        --this.i;
    }

    @Override
    public char history(int idx) {
        return this.s.charAt(idx);
    }
}

