/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import zio.json.JsonDecoder$;
import zio.json.JsonDecoder$UnsafeJson$;
import zio.json.JsonError;
import zio.json.JsonError$Message$;
import zio.json.internal.OneCharReader;
import zio.json.internal.RetractReader;
import zio.json.internal.StringMatrix;
import zio.json.internal.UnexpectedEnd;
import zio.json.internal.UnsafeNumbers$;
import zio.json.internal.UnsafeNumbers$UnsafeNumber$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Lexer$
implements Serializable {
    private static final int NumberMaxBits;
    public static final Lexer$ MODULE$;

    private Lexer$() {
    }

    static {
        MODULE$ = new Lexer$();
        NumberMaxBits = 256;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Lexer$.class);
    }

    public int NumberMaxBits() {
        return NumberMaxBits;
    }

    public Nothing$ error(String msg, List<JsonError> trace) {
        JsonDecoder$.MODULE$.JsonError();
        JsonError.Message message = JsonError$Message$.MODULE$.apply(msg);
        throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public Nothing$ error(String expected, char got, List<JsonError> trace) {
        return this.error(new StringBuilder(16).append("expected ").append(expected).append(" got '").append(got).append("'").toString(), trace);
    }

    public Nothing$ error(char c, List<JsonError> trace) {
        return this.error(new StringBuilder(21).append("invalid '\\").append(c).append("' in string").toString(), trace);
    }

    public boolean firstField(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        if ('\"' == c) {
            in.retract();
            return true;
        }
        if ('}' == c) {
            return false;
        }
        char c2 = c;
        throw this.error("string or '}'", c2, trace);
    }

    public boolean nextField(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (',' == c) {
            return true;
        }
        if ('}' == c) {
            return false;
        }
        char c2 = c;
        throw this.error("',' or '}'", c2, trace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean firstArrayElement(RetractReader in) {
        if (in.nextNonWhitespace() == ']') return false;
        in.retract();
        if (!true) return false;
        return true;
    }

    public boolean nextArrayElement(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (',' == c) {
            return true;
        }
        if (']' == c) {
            return false;
        }
        char c2 = c;
        throw this.error("',' or ']'", c2, trace);
    }

    public int field(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        int f = this.enumeration(trace, in, matrix);
        char c = in.nextNonWhitespace();
        if (c != ':') {
            throw this.error("':'", c, trace);
        }
        return f;
    }

    public int enumeration(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        char c = in.nextNonWhitespace();
        if (c != '\"') {
            throw this.error("'\"'", c, trace);
        }
        long bs = matrix.initial();
        int i = 0;
        while ((c = in.readChar()) != '\"') {
            block15: {
                block14: {
                    if (c != '\\') break block14;
                    char c2 = in.readChar();
                    switch (c2) {
                        case '\"': {
                            c = '\"';
                            break block15;
                        }
                        case '\\': {
                            c = '\\';
                            break block15;
                        }
                        case '/': {
                            c = '/';
                            break block15;
                        }
                        case 'b': {
                            c = '\b';
                            break block15;
                        }
                        case 'f': {
                            c = '\f';
                            break block15;
                        }
                        case 'n': {
                            c = '\n';
                            break block15;
                        }
                        case 'r': {
                            c = '\r';
                            break block15;
                        }
                        case 't': {
                            c = '\t';
                            break block15;
                        }
                        case 'u': {
                            c = this.nextHex4(trace, in);
                            break block15;
                        }
                        default: {
                            throw this.error(c, trace);
                        }
                    }
                }
                if (c < ' ') {
                    throw this.error("invalid control in string", trace);
                }
            }
            bs = matrix.update(bs, i, c);
            ++i;
        }
        bs = matrix.exact(bs, i);
        return matrix.first(bs);
    }

    public void skipValue(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case 'n': 
            case 't': {
                this.skipFixedChars(in, 3);
                return;
            }
            case 'f': {
                this.skipFixedChars(in, 4);
                return;
            }
            case '{': {
                this.skipObject(in, 0);
                return;
            }
            case '[': {
                this.skipArray(in, 0);
                return;
            }
            case '\"': {
                this.skipString(in, true);
                return;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.skipNumber(in);
                return;
            }
        }
        char c2 = c;
        throw this.error(new StringBuilder(13).append("unexpected '").append(c2).append("'").toString(), trace);
    }

    public void skipNumber(RetractReader in) {
        while (this.isNumber(in.readChar())) {
        }
        in.retract();
    }

    public void skipString(List<JsonError> trace, OneCharReader in) {
        this.skipString(in, true);
    }

    private void skipFixedChars(OneCharReader in, int n) {
        while (n > 0) {
            in.readChar();
            --n;
        }
    }

    private void skipString(OneCharReader in, boolean evenBackSlashes) {
        while (true) {
            char ch = in.readChar();
            if (evenBackSlashes) {
                if (ch != '\"') {
                    evenBackSlashes = ch != '\\';
                    continue;
                }
                return;
            }
            evenBackSlashes = true;
        }
    }

    private void skipObject(OneCharReader in, int level) {
        while (true) {
            char ch;
            if ((ch = in.readChar()) == '\"') {
                this.skipString(in, true);
                continue;
            }
            if (ch == '{') {
                ++level;
                continue;
            }
            if (ch != '}') continue;
            if (level == 0) break;
            --level;
        }
    }

    private void skipArray(OneCharReader in, int level) {
        while (true) {
            char b;
            if ((b = in.readChar()) == '\"') {
                this.skipString(in, true);
                continue;
            }
            if (b == '[') {
                ++level;
                continue;
            }
            if (b != ']') continue;
            if (level == 0) break;
            --level;
        }
    }

    public Reader streamingString(List<JsonError> trace, OneCharReader in) {
        this.char(trace, in, '\"');
        return (Reader)((Object)new OneCharReader(in, trace){
            private final OneCharReader in$1;
            private final List trace$1;
            private boolean escaped;
            {
                this.in$1 = in$2;
                this.trace$1 = trace$2;
                this.escaped = false;
            }

            public void close() {
                ((Reader)((Object)this.in$1)).close();
            }

            public int read() {
                char c;
                while (true) {
                    c = this.in$1.readChar();
                    if (this.escaped) {
                        int n;
                        this.escaped = false;
                        char c2 = c;
                        switch (c2) {
                            case '\"': 
                            case '/': 
                            case '\\': {
                                n = c;
                                break;
                            }
                            case 'b': {
                                n = 8;
                                break;
                            }
                            case 'f': {
                                n = 12;
                                break;
                            }
                            case 'n': {
                                n = 10;
                                break;
                            }
                            case 'r': {
                                n = 13;
                                break;
                            }
                            case 't': {
                                n = 9;
                                break;
                            }
                            case 'u': {
                                n = Lexer$.MODULE$.nextHex4((List<JsonError>)this.trace$1, this.in$1);
                                break;
                            }
                            default: {
                                throw Lexer$.MODULE$.error(c, (List<JsonError>)this.trace$1);
                            }
                        }
                        return n;
                    }
                    if (c != '\\') break;
                    this.escaped = true;
                }
                if (c == '\"') {
                    return -1;
                }
                if (c < ' ') {
                    throw Lexer$.MODULE$.error("invalid control in string", (List<JsonError>)this.trace$1);
                }
                return c;
            }

            public char readChar() {
                int v = this.read();
                if (v == -1) {
                    throw new UnexpectedEnd();
                }
                return (char)v;
            }
        });
    }

    public CharSequence string(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c != '\"') {
            throw this.error("'\"'", c, trace);
        }
        char[] cs = new char[64];
        int i = 0;
        while ((c = in.readChar()) != '\"') {
            block16: {
                block15: {
                    if (c != '\\') break block15;
                    char c2 = in.readChar();
                    switch (c2) {
                        case '\"': {
                            c = '\"';
                            break block16;
                        }
                        case '\\': {
                            c = '\\';
                            break block16;
                        }
                        case '/': {
                            c = '/';
                            break block16;
                        }
                        case 'b': {
                            c = '\b';
                            break block16;
                        }
                        case 'f': {
                            c = '\f';
                            break block16;
                        }
                        case 'n': {
                            c = '\n';
                            break block16;
                        }
                        case 'r': {
                            c = '\r';
                            break block16;
                        }
                        case 't': {
                            c = '\t';
                            break block16;
                        }
                        case 'u': {
                            c = this.nextHex4(trace, in);
                            break block16;
                        }
                        default: {
                            throw this.error(c, trace);
                        }
                    }
                }
                if (c < ' ') {
                    throw this.error("invalid control in string", trace);
                }
            }
            if (i == cs.length) {
                cs = Arrays.copyOf(cs, i << 1);
            }
            cs[i] = c;
            ++i;
        }
        return new String(cs, 0, i);
    }

    public char char(List<JsonError> trace, OneCharReader in) {
        char c;
        block19: {
            block16: {
                block18: {
                    block17: {
                        c = in.nextNonWhitespace();
                        if (c != '\"') {
                            throw this.error("'\"'", c, trace);
                        }
                        c = in.readChar();
                        if (c == '\"') break block16;
                        if (c != '\\') break block17;
                        char c2 = in.readChar();
                        switch (c2) {
                            case '\"': {
                                c = '\"';
                                break block18;
                            }
                            case '\\': {
                                c = '\\';
                                break block18;
                            }
                            case '/': {
                                c = '/';
                                break block18;
                            }
                            case 'b': {
                                c = '\b';
                                break block18;
                            }
                            case 'f': {
                                c = '\f';
                                break block18;
                            }
                            case 'n': {
                                c = '\n';
                                break block18;
                            }
                            case 'r': {
                                c = '\r';
                                break block18;
                            }
                            case 't': {
                                c = '\t';
                                break block18;
                            }
                            case 'u': {
                                c = this.nextHex4(trace, in);
                                break block18;
                            }
                            default: {
                                throw this.error(c, trace);
                            }
                        }
                    }
                    if (c < ' ') {
                        throw this.error("invalid control in string", trace);
                    }
                }
                if (in.readChar() == '\"') break block19;
            }
            throw this.error("expected single character string", trace);
        }
        return c;
    }

    public char nextHex4(List<JsonError> trace, OneCharReader in) {
        int accum = 0;
        for (int i = 0; i < 4; ++i) {
            int n;
            char c = in.readChar();
            accum <<= 4;
            if ('0' <= c && c <= '9') {
                n = c - 48;
            } else if ('A' <= c && c <= 'F') {
                n = c - 65 + 10;
            } else if ('a' <= c && c <= 'f') {
                n = c - 97 + 10;
            } else {
                throw this.error("invalid charcode in string", trace);
            }
            accum += n;
        }
        return (char)accum;
    }

    public boolean boolean(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if ('t' == c) {
            if (in.readChar() != 'r' || in.readChar() != 'u' || in.readChar() != 'e') {
                throw this.error("expected 'true'", trace);
            }
            return true;
        }
        if ('f' == c) {
            if (in.readChar() != 'a' || in.readChar() != 'l' || in.readChar() != 's' || in.readChar() != 'e') {
                throw this.error("expected 'false'", trace);
            }
            return false;
        }
        char c2 = c;
        throw this.error("'true' or 'false'", c2, trace);
    }

    /*
     * WARNING - void declaration
     */
    public byte byte(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            byte i = UnsafeNumbers$.MODULE$.byte_(in, false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error("expected a Byte", trace);
        }
        return (byte)v0;
    }

    /*
     * WARNING - void declaration
     */
    public short short(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            short i = UnsafeNumbers$.MODULE$.short_(in, false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error("expected a Short", trace);
        }
        return (short)v0;
    }

    /*
     * WARNING - void declaration
     */
    public int int(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            int i = UnsafeNumbers$.MODULE$.int_(in, false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error("expected an Int", trace);
        }
        return (int)v0;
    }

    /*
     * WARNING - void declaration
     */
    public long long(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            long i = UnsafeNumbers$.MODULE$.long_(in, false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error("expected a Long", trace);
        }
        return (long)v0;
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger bigInteger(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            BigInteger i = UnsafeNumbers$.MODULE$.bigInteger_(in, false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error(new StringBuilder(26).append("expected a ").append(this.NumberMaxBits()).append(" bit BigInteger").toString(), trace);
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public float float(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            float i = UnsafeNumbers$.MODULE$.float_(in, false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error("expected a Float", trace);
        }
        return (float)v0;
    }

    /*
     * WARNING - void declaration
     */
    public double double(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            double i = UnsafeNumbers$.MODULE$.double_(in, false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error("expected a Double", trace);
        }
        return (double)v0;
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal bigDecimal(List<JsonError> trace, RetractReader in) {
        void v0;
        try {
            void var3_3;
            BigDecimal i = UnsafeNumbers$.MODULE$.bigDecimal_(in, false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw this.error(new StringBuilder(22).append("expected a ").append(this.NumberMaxBits()).append(" BigDecimal").toString(), trace);
        }
        return v0;
    }

    public void char(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.nextNonWhitespace();
        if (got != c) {
            throw this.error(new StringBuilder(2).append("'").append(c).append("'").toString(), got, trace);
        }
    }

    public void charOnly(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.readChar();
        if (got != c) {
            throw this.error(new StringBuilder(2).append("'").append(c).append("'").toString(), got, trace);
        }
    }

    private boolean isNumber(char c) {
        char c2 = c;
        switch (c2) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'E': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    public void readChars(List<JsonError> trace, OneCharReader in, char[] expect, String errMsg) {
        for (int i = 0; i < expect.length; ++i) {
            if (in.readChar() == expect[i]) continue;
            throw this.error(new StringBuilder(11).append("expected '").append(errMsg).append("'").toString(), trace);
        }
    }
}

