/*
 * Decompiled with CFR 0.152.
 */
package zio.json;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.UUID;
import scala.Function1;
import scala.collection.immutable.List;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.json.DecoderLowPriority4;
import zio.json.JsonDecoder;
import zio.json.JsonError;
import zio.json.ast.Json;
import zio.json.ast.Json$Str$;
import zio.json.internal.Lexer$;
import zio.json.internal.RetractReader;
import zio.json.javatime.parsers$;
import zio.json.uuid.UUIDParser$;

public interface DecoderLowPriority3
extends DecoderLowPriority4 {
    public static void $init$(DecoderLowPriority3 $this) {
        $this.zio$json$DecoderLowPriority3$_setter_$dayOfWeek_$eq($this.javaTimeDecoder((Function1 & Serializable)s -> DayOfWeek.valueOf(s.toUpperCase())));
        $this.zio$json$DecoderLowPriority3$_setter_$duration_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseDuration((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$instant_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseInstant((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$localDate_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseLocalDate((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$localDateTime_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseLocalDateTime((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$localTime_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseLocalTime((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$month_$eq($this.javaTimeDecoder((Function1 & Serializable)s -> Month.valueOf(s.toUpperCase())));
        $this.zio$json$DecoderLowPriority3$_setter_$monthDay_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseMonthDay((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$offsetDateTime_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseOffsetDateTime((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$offsetTime_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseOffsetTime((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$period_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParsePeriod((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$year_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseYear((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$yearMonth_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseYearMonth((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$zonedDateTime_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseZonedDateTime((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$zoneId_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseZoneId((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$zoneOffset_$eq($this.javaTimeDecoder((Function1 & Serializable)input -> parsers$.MODULE$.unsafeParseZoneOffset((String)input)));
        $this.zio$json$DecoderLowPriority3$_setter_$uuid_$eq(new JsonDecoder<UUID>($this){
            private final /* synthetic */ DecoderLowPriority3 $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public UUID unsafeDecode(List trace, RetractReader in) {
                return this.parseUUID(trace, Lexer$.MODULE$.string((List<JsonError>)trace, in).toString());
            }

            public final UUID unsafeFromJsonAST(List trace, Json json) {
                Json json2 = json;
                if (json2 instanceof Json.Str) {
                    String string;
                    Json.Str str = Json$Str$.MODULE$.unapply((Json.Str)json2);
                    String value = string = str._1();
                    return this.parseUUID(trace, value);
                }
                throw Lexer$.MODULE$.error("expected string", (List<JsonError>)trace);
            }

            private UUID parseUUID(List trace, String s) {
                UUID uUID;
                try {
                    uUID = UUIDParser$.MODULE$.unsafeParse(s);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Lexer$.MODULE$.error(new StringBuilder(14).append("Invalid UUID: ").append(this.$outer.strip(s, this.$outer.strip$default$2())).toString(), (List<JsonError>)trace);
                }
                return uUID;
            }
        });
        $this.zio$json$DecoderLowPriority3$_setter_$currency_$eq(new JsonDecoder<Currency>($this){
            private final /* synthetic */ DecoderLowPriority3 $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Currency unsafeDecode(List trace, RetractReader in) {
                return this.parseCurrency(trace, Lexer$.MODULE$.string((List<JsonError>)trace, in).toString());
            }

            public final Currency unsafeFromJsonAST(List trace, Json json) {
                Json json2 = json;
                if (json2 instanceof Json.Str) {
                    String string;
                    Json.Str str = Json$Str$.MODULE$.unapply((Json.Str)json2);
                    String value = string = str._1();
                    return this.parseCurrency(trace, value);
                }
                throw Lexer$.MODULE$.error("expected string", (List<JsonError>)trace);
            }

            private Currency parseCurrency(List trace, String s) {
                Currency currency;
                try {
                    currency = Currency.getInstance(s);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Lexer$.MODULE$.error(new StringBuilder(18).append("Invalid Currency: ").append(this.$outer.strip(s, this.$outer.strip$default$2())).toString(), (List<JsonError>)trace);
                }
                return currency;
            }
        });
    }

    public JsonDecoder<DayOfWeek> dayOfWeek();

    public void zio$json$DecoderLowPriority3$_setter_$dayOfWeek_$eq(JsonDecoder var1);

    public JsonDecoder<Duration> duration();

    public void zio$json$DecoderLowPriority3$_setter_$duration_$eq(JsonDecoder var1);

    public JsonDecoder<Instant> instant();

    public void zio$json$DecoderLowPriority3$_setter_$instant_$eq(JsonDecoder var1);

    public JsonDecoder<LocalDate> localDate();

    public void zio$json$DecoderLowPriority3$_setter_$localDate_$eq(JsonDecoder var1);

    public JsonDecoder<LocalDateTime> localDateTime();

    public void zio$json$DecoderLowPriority3$_setter_$localDateTime_$eq(JsonDecoder var1);

    public JsonDecoder<LocalTime> localTime();

    public void zio$json$DecoderLowPriority3$_setter_$localTime_$eq(JsonDecoder var1);

    public JsonDecoder<Month> month();

    public void zio$json$DecoderLowPriority3$_setter_$month_$eq(JsonDecoder var1);

    public JsonDecoder<MonthDay> monthDay();

    public void zio$json$DecoderLowPriority3$_setter_$monthDay_$eq(JsonDecoder var1);

    public JsonDecoder<OffsetDateTime> offsetDateTime();

    public void zio$json$DecoderLowPriority3$_setter_$offsetDateTime_$eq(JsonDecoder var1);

    public JsonDecoder<OffsetTime> offsetTime();

    public void zio$json$DecoderLowPriority3$_setter_$offsetTime_$eq(JsonDecoder var1);

    public JsonDecoder<Period> period();

    public void zio$json$DecoderLowPriority3$_setter_$period_$eq(JsonDecoder var1);

    public JsonDecoder<Year> year();

    public void zio$json$DecoderLowPriority3$_setter_$year_$eq(JsonDecoder var1);

    public JsonDecoder<YearMonth> yearMonth();

    public void zio$json$DecoderLowPriority3$_setter_$yearMonth_$eq(JsonDecoder var1);

    public JsonDecoder<ZonedDateTime> zonedDateTime();

    public void zio$json$DecoderLowPriority3$_setter_$zonedDateTime_$eq(JsonDecoder var1);

    public JsonDecoder<ZoneId> zoneId();

    public void zio$json$DecoderLowPriority3$_setter_$zoneId_$eq(JsonDecoder var1);

    public JsonDecoder<ZoneOffset> zoneOffset();

    public void zio$json$DecoderLowPriority3$_setter_$zoneOffset_$eq(JsonDecoder var1);

    private <A> JsonDecoder<A> javaTimeDecoder(Function1<String, A> f) {
        return new JsonDecoder<A>(f, this){
            private final Function1 f$6;
            private final /* synthetic */ DecoderLowPriority3 $outer;
            {
                this.f$6 = f$12;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object unsafeDecode(List trace, RetractReader in) {
                return this.parseJavaTime(trace, Lexer$.MODULE$.string((List<JsonError>)trace, in).toString());
            }

            public final Object unsafeFromJsonAST(List trace, Json json) {
                Json json2 = json;
                if (json2 instanceof Json.Str) {
                    String string;
                    Json.Str str = Json$Str$.MODULE$.unapply((Json.Str)json2);
                    String value = string = str._1();
                    return this.parseJavaTime(trace, value);
                }
                throw Lexer$.MODULE$.error("expected string", (List<JsonError>)trace);
            }

            private Object parseJavaTime(List trace, String s) {
                Object object;
                try {
                    object = this.f$6.apply((Object)s);
                }
                catch (DateTimeException ex) {
                    throw Lexer$.MODULE$.error(new StringBuilder(33).append(this.$outer.strip(s, this.$outer.strip$default$2())).append(" is not a valid ISO-8601 format, ").append(ex.getMessage()).toString(), (List<JsonError>)trace);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Lexer$.MODULE$.error(new StringBuilder(31).append(this.$outer.strip(s, this.$outer.strip$default$2())).append(" is not a valid ISO-8601 format").toString(), (List<JsonError>)trace);
                }
                return object;
            }
        };
    }

    public static Either parseJavaTime$(DecoderLowPriority3 $this, Function1 f, String s) {
        return $this.parseJavaTime(f, s);
    }

    default public <A> Either<String, A> parseJavaTime(Function1<String, A> f, String s) {
        Right right;
        try {
            right = new Right(f.apply((Object)s));
        }
        catch (DateTimeException ex) {
            right = new Left((Object)new StringBuilder(33).append(this.strip(s, this.strip$default$2())).append(" is not a valid ISO-8601 format, ").append(ex.getMessage()).toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            right = new Left((Object)new StringBuilder(31).append(this.strip(s, this.strip$default$2())).append(" is not a valid ISO-8601 format").toString());
        }
        return right;
    }

    public JsonDecoder<UUID> uuid();

    public void zio$json$DecoderLowPriority3$_setter_$uuid_$eq(JsonDecoder var1);

    public JsonDecoder<Currency> currency();

    public void zio$json$DecoderLowPriority3$_setter_$currency_$eq(JsonDecoder var1);

    public static String strip$(DecoderLowPriority3 $this, String s, int len) {
        return $this.strip(s, len);
    }

    default public String strip(String s, int len) {
        if (s.length() <= len) {
            return s;
        }
        return new StringBuilder(3).append(s.substring(0, len)).append("...").toString();
    }

    public static int strip$default$2$(DecoderLowPriority3 $this) {
        return $this.strip$default$2();
    }

    default public int strip$default$2() {
        return 50;
    }
}

