/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.testing;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.model.Method;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointOutput;
import sttp.tapir.internal.UrlencodedData$;
import sttp.tapir.testing.DuplicatedMethodDefinitionError;
import sttp.tapir.testing.EndpointVerificationError;
import sttp.tapir.testing.FixedPathSegment;
import sttp.tapir.testing.IncorrectPathsError;
import sttp.tapir.testing.PathComponent;
import sttp.tapir.testing.PathVariableSegment$;
import sttp.tapir.testing.ShadowedEndpointError;
import sttp.tapir.testing.UnexpectedBodyError;
import sttp.tapir.testing.WildcardPathSegment$;
import sttp.tapir.typelevel.ParamConcat$;
import sttp.tapir.typelevel.TupleOps;

public final class EndpointVerifier$ {
    public static final EndpointVerifier$ MODULE$ = new EndpointVerifier$();

    public Set<EndpointVerificationError> apply(List<Endpoint<?, ?, ?, ?, ?>> endpoints) {
        return (Set)((SetOps)((IterableOnceOps)this.findShadowedEndpoints(endpoints, (List<ShadowedEndpointError>)Nil$.MODULE$).groupBy((Function1 & Serializable)x$1 -> x$1.e()).map((Function1 & Serializable)x$2 -> (ShadowedEndpointError)((IterableOps)x$2._2()).head())).toSet().$plus$plus((IterableOnce)this.findIncorrectPaths(endpoints).toSet()).$plus$plus((IterableOnce)this.findDuplicatedMethodDefinitions(endpoints).toSet())).$plus$plus((IterableOnce)this.findIncorrectStatusWithBody(endpoints).toSet());
    }

    private List<IncorrectPathsError> findIncorrectPaths(List<Endpoint<?, ?, ?, ?, ?>> endpoints) {
        return endpoints.map((Function1 & Serializable)e -> {
            Vector<PathComponent> paths = MODULE$.extractPathSegments((Endpoint<?, ?, ?, ?, ?>)e);
            int wildCardIndex = paths.indexOf((Object)WildcardPathSegment$.MODULE$);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((!((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{paths.length() - 1, -1}))).contains((Object)BoxesRunTime.boxToInteger((int)wildCardIndex)) ? 1 : 0) != 0), (Object)new IncorrectPathsError((Endpoint<?, ?, ?, ?, ?>)e, wildCardIndex));
        }).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3._1$mcZ$sp())).map((Function1 & Serializable)x$4 -> (IncorrectPathsError)x$4._2());
    }

    private List<ShadowedEndpointError> findShadowedEndpoints(List<Endpoint<?, ?, ?, ?, ?>> endpoints, List<ShadowedEndpointError> acc) {
        List list;
        while ((list = endpoints) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Endpoint endpoint = (Endpoint)colon2.head();
            List endpoints2 = colon2.next$access$1();
            List list2 = acc;
            acc = this.findAllShadowedByEndpoint(endpoint, endpoints2).$colon$colon$colon(list2);
            endpoints = endpoints2;
        }
        if (Nil$.MODULE$.equals(list)) {
            return acc;
        }
        throw new MatchError(list);
    }

    private List<ShadowedEndpointError> findAllShadowedByEndpoint(Endpoint<?, ?, ?, ?, ?> endpoint, List<Endpoint<?, ?, ?, ?, ?>> in) {
        return in.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)EndpointVerifier$.MODULE$.checkIfShadows(endpoint, e))).map((Function1 & Serializable)e -> new ShadowedEndpointError((Endpoint<?, ?, ?, ?, ?>)e, endpoint));
    }

    private List<UnexpectedBodyError> findIncorrectStatusWithBody(List<Endpoint<?, ?, ?, ?, ?>> endpoints) {
        return endpoints.flatMap((Function1 & Serializable)e -> {
            List outputs = (List)sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(e.output()).asBasicOutputsList().$plus$plus((IterableOnce)sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(e.errorOutput()).asBasicOutputsList());
            return outputs.flatMap((Function1 & Serializable)outputElems -> {
                boolean hasBody = outputElems.collectFirst((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends EndpointOutput.Basic<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof EndpointIO.Body) {
                            EndpointIO.Body body = (EndpointIO.Body)A1;
                            return (B1)body;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(EndpointOutput.Basic<?> x1) {
                        EndpointOutput.Basic<?> basic = x1;
                        return basic instanceof EndpointIO.Body;
                    }
                }).isDefined();
                Vector noBodyStatusCodes = (Vector)outputElems.collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends EndpointOutput.Basic<?>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        boolean bl = false;
                        EndpointOutput.FixedStatusCode fixedStatusCode = null;
                        A1 A1 = x2;
                        if (A1 instanceof EndpointOutput.FixedStatusCode) {
                            bl = true;
                            fixedStatusCode = (EndpointOutput.FixedStatusCode)A1;
                            int n = fixedStatusCode.statusCode();
                            if (StatusCode$.MODULE$.NoContent() == n) {
                                return (B1)new StatusCode(StatusCode$.MODULE$.NoContent());
                            }
                        }
                        if (bl) {
                            int n = fixedStatusCode.statusCode();
                            if (StatusCode$.MODULE$.NotModified() == n) {
                                return (B1)new StatusCode(StatusCode$.MODULE$.NotModified());
                            }
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(EndpointOutput.Basic<?> x2) {
                        boolean bl = false;
                        EndpointOutput.FixedStatusCode fixedStatusCode = null;
                        EndpointOutput.Basic<?> basic = x2;
                        if (basic instanceof EndpointOutput.FixedStatusCode) {
                            bl = true;
                            fixedStatusCode = (EndpointOutput.FixedStatusCode)basic;
                            int n = fixedStatusCode.statusCode();
                            if (StatusCode$.MODULE$.NoContent() == n) {
                                return true;
                            }
                        }
                        if (bl) {
                            int n = fixedStatusCode.statusCode();
                            if (StatusCode$.MODULE$.NotModified() == n) {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                if (hasBody) {
                    return (IterableOnce)noBodyStatusCodes.map((Function1 & Serializable)x$5 -> EndpointVerifier$.$anonfun$findIncorrectStatusWithBody$3(e, ((StatusCode)x$5).code()));
                }
                return Nil$.MODULE$;
            });
        });
    }

    private boolean checkIfShadows(Endpoint<?, ?, ?, ?, ?> e1, Endpoint<?, ?, ?, ?, ?> e2) {
        return this.checkMethods(e1, e2) && this.checkPaths(e1, e2);
    }

    private boolean checkMethods(Endpoint<?, ?, ?, ?, ?> e1, Endpoint<?, ?, ?, ?, ?> e2) {
        return e1.method().equals((Object)e2.method()) || e1.method().isEmpty();
    }

    private boolean checkPaths(Endpoint<?, ?, ?, ?, ?> e1, Endpoint<?, ?, ?, ?, ?> e2) {
        Vector<PathComponent> e1Segments = this.extractPathSegments(e1);
        Vector<PathComponent> e2Segments = this.extractPathSegments(e2);
        Vector commonSegments = (Vector)((StrictOptimizedIterableOps)e1Segments.zip(e2Segments)).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)EndpointVerifier$.$anonfun$checkPaths$1(p)));
        if (e1Segments.size() == commonSegments.size() && e1Segments.size() == e2Segments.size()) {
            return true;
        }
        if (e1Segments.size() == commonSegments.size() && this.endsWithWildcard(e1Segments)) {
            return true;
        }
        return e1Segments.size() - 1 == commonSegments.size() && e2Segments.size() == commonSegments.size() && this.endsWithWildcard(e1Segments);
    }

    private boolean endsWithWildcard(Vector<PathComponent> paths) {
        return paths.nonEmpty() && paths.indexOf((Object)WildcardPathSegment$.MODULE$) == paths.size() - 1;
    }

    private Vector<PathComponent> extractPathSegments(Endpoint<?, ?, ?, ?, ?> endpoint) {
        return this.inputPathSegments(endpoint.securityInput().and(endpoint.input(), ParamConcat$.MODULE$.concatSingleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1()))))));
    }

    private Vector<PathComponent> inputPathSegments(EndpointInput<?> input) {
        return sttp.tapir.internal.package$.MODULE$.RichEndpointInput(input).traverseInputs((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends EndpointInput<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EndpointInput.FixedPath) {
                    EndpointInput.FixedPath fixedPath = (EndpointInput.FixedPath)A1;
                    String x = fixedPath.s();
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FixedPathSegment[]{new FixedPathSegment(UrlencodedData$.MODULE$.encode(x))}));
                }
                if (A1 instanceof EndpointInput.PathsCapture) {
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WildcardPathSegment$[]{WildcardPathSegment$.MODULE$}));
                }
                if (A1 instanceof EndpointInput.PathCapture) {
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathVariableSegment$[]{PathVariableSegment$.MODULE$}));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(EndpointInput<?> x1) {
                EndpointInput<?> endpointInput = x1;
                if (endpointInput instanceof EndpointInput.FixedPath) {
                    return true;
                }
                if (endpointInput instanceof EndpointInput.PathsCapture) {
                    return true;
                }
                return endpointInput instanceof EndpointInput.PathCapture;
            }
        });
    }

    private List<EndpointVerificationError> findDuplicatedMethodDefinitions(List<Endpoint<?, ?, ?, ?, ?>> endpoints) {
        return endpoints.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e), (Object)MODULE$.inputDefinedMethods(e.input()).toList())).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)EndpointVerifier$.$anonfun$findDuplicatedMethodDefinitions$2(x$6))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Endpoint endpoint = (Endpoint)tuple2._1();
                List methods = (List)tuple2._2();
                return new DuplicatedMethodDefinitionError(endpoint, (List<Method>)methods);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Vector<Method> inputDefinedMethods(EndpointInput<?> input) {
        return sttp.tapir.internal.package$.MODULE$.RichEndpointInput(input).traverseInputs((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends EndpointInput<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EndpointInput.FixedMethod) {
                    EndpointInput.FixedMethod fixedMethod = (EndpointInput.FixedMethod)A1;
                    String m = fixedMethod.m();
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Method[]{new Method(m)}));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(EndpointInput<?> x1) {
                EndpointInput<?> endpointInput = x1;
                return endpointInput instanceof EndpointInput.FixedMethod;
            }
        });
    }

    public static final /* synthetic */ UnexpectedBodyError $anonfun$findIncorrectStatusWithBody$3(Endpoint e$1, int x$5) {
        return new UnexpectedBodyError(e$1, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$checkPaths$1(Tuple2 p) {
        return p._1().equals(WildcardPathSegment$.MODULE$) || p._1().equals(p._2()) || p._1().equals(PathVariableSegment$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$findDuplicatedMethodDefinitions$2(Tuple2 x$6) {
        return ((List)x$6._2()).length() > 1;
    }

    private EndpointVerifier$() {
    }
}

