/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.pekkohttp;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sttp.client4.BodyPart;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteBufferBody;
import sttp.client4.FileBody;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StringBody;
import sttp.client4.compression.Compressor;
import sttp.client4.compression.Compressor$;
import sttp.client4.internal.SttpFile;
import sttp.client4.pekkohttp.ToPekko$;
import sttp.client4.pekkohttp.Util$;
import sttp.model.Header;
import sttp.model.Part;

public final class BodyToPekko$ {
    public static BodyToPekko$ MODULE$;

    static {
        new BodyToPekko$();
    }

    public <R> Try<HttpRequest> apply(GenericRequest<?, R> r, HttpRequest ar, List<Compressor<R>> compressors) {
        Tuple2 tuple2 = Compressor$.MODULE$.compressIfNeeded(r, compressors);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GenericRequestBody body = (GenericRequestBody)tuple2._1();
        Option contentLength = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)body, (Object)contentLength);
        GenericRequestBody body2 = (GenericRequestBody)tuple22._1();
        Option contentLength2 = (Option)tuple22._2();
        return Util$.MODULE$.parseContentTypeOrOctetStream(r).flatMap((Function1 & Serializable & scala.Serializable)ct -> {
            GenericRequestBody genericRequestBody = body2;
            if (NoBody$.MODULE$.equals(genericRequestBody)) {
                return new Success((Object)ar);
            }
            if (genericRequestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)genericRequestBody;
                String b = stringBody.s();
                String encoding = stringBody.encoding();
                return new Success((Object)ar.withEntity((org.apache.pekko.http.javadsl.model.ContentType)BodyToPekko$.ctWithCharset$1(ct, encoding), b.getBytes(encoding)));
            }
            if (genericRequestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)genericRequestBody;
                byte[] b = byteArrayBody.b();
                return new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, b)));
            }
            if (genericRequestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = (ByteBufferBody)genericRequestBody;
                ByteBuffer b = byteBufferBody.b();
                return new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b))));
            }
            if (genericRequestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)genericRequestBody;
                InputStream b = inputStreamBody.b();
                return new Success((Object)ar.withEntity(BodyToPekko$.streamEntity$1(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> b, StreamConverters$.MODULE$.fromInputStream$default$2()), contentLength2)));
            }
            if (genericRequestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)genericRequestBody;
                SttpFile b = fileBody.f();
                return new Success((Object)ar.withEntity((org.apache.pekko.http.javadsl.model.ContentType)ct, b.toPath()));
            }
            if (genericRequestBody instanceof StreamBody) {
                StreamBody streamBody = (StreamBody)genericRequestBody;
                Object s = streamBody.b();
                return new Success((Object)ar.withEntity(BodyToPekko$.streamEntity$1(ct, (Source)s, contentLength2)));
            }
            if (genericRequestBody instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)genericRequestBody;
                return Util$.MODULE$.traverseTry((Seq)multipartBody.parts().map((Function1 & Serializable & scala.Serializable)mp -> BodyToPekko$.toBodyPart$1(mp), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)bodyParts -> MODULE$.multipartEntity(r, (Seq<Multipart.FormData.BodyPart>)bodyParts).map((Function1 & Serializable & scala.Serializable)entity -> ar.withEntity(entity)));
            }
            throw new MatchError((Object)genericRequestBody);
        });
    }

    private Try<RequestEntity> multipartEntity(GenericRequest<?, ?> r, Seq<Multipart.FormData.BodyPart> bodyParts) {
        Option option = r.headers().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)Util$.MODULE$.isContentType(header)));
        if (None$.MODULE$.equals(option)) {
            return new Success((Object)Multipart.FormData$.MODULE$.apply(bodyParts).toEntity());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Header ct = (Header)some.value();
            return Util$.MODULE$.parseContentType(ct.value()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.mediaType()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MediaType mediaType = x0$1;
                if (mediaType instanceof MediaType.Multipart) {
                    MediaType.Multipart multipart = (MediaType.Multipart)mediaType;
                    return new Success((Object)Multipart.General$.MODULE$.apply(multipart, Source$.MODULE$.apply((Iterable)bodyParts.map((Function1 & Serializable & scala.Serializable)bp -> Multipart.General$.BodyPart$.MODULE$.apply(bp.entity(), bp.headers()), Seq$.MODULE$.canBuildFrom()))).toEntity());
                }
                return new Failure((Throwable)new RuntimeException(new StringBuilder(28).append("Non-multipart content type: ").append(ct).toString()));
            });
        }
        throw new MatchError((Object)option);
    }

    private static final ContentType ctWithCharset$1(ContentType ct, String charset) {
        return (ContentType)HttpCharsets$.MODULE$.getForKey((Object)charset).map((Function1 & Serializable & scala.Serializable)hc -> ContentType$.MODULE$.apply(ct.mediaType(), (Function0 & Serializable & scala.Serializable)() -> hc)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ct);
    }

    private static final BodyPartEntity streamPartEntity$1(ContentType contentType, Source s, Part mp$1) {
        Option option = mp$1.contentLength();
        if (None$.MODULE$.equals(option)) {
            return new HttpEntity.IndefiniteLength(contentType, s);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long l = BoxesRunTime.unboxToLong((Object)some.value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }

    private static final BodyPartEntity entity$1(ContentType ct, Part mp$1) {
        BodyPart bodyPart = (BodyPart)mp$1.body();
        if (bodyPart instanceof StringBody) {
            StringBody stringBody = (StringBody)bodyPart;
            String b = stringBody.s();
            String encoding = stringBody.encoding();
            return HttpEntity$.MODULE$.apply(BodyToPekko$.ctWithCharset$1(ct, encoding), b.getBytes(encoding));
        }
        if (bodyPart instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)bodyPart;
            byte[] b = byteArrayBody.b();
            return HttpEntity$.MODULE$.apply(ct, b);
        }
        if (bodyPart instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)bodyPart;
            ByteBuffer b = byteBufferBody.b();
            return HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b));
        }
        if (bodyPart instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)bodyPart;
            return BodyToPekko$.streamPartEntity$1(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> inputStreamBody.b(), StreamConverters$.MODULE$.fromInputStream$default$2()), mp$1);
        }
        if (bodyPart instanceof FileBody) {
            FileBody fileBody = (FileBody)bodyPart;
            SttpFile b = fileBody.f();
            return HttpEntity$.MODULE$.fromPath(ct, b.toPath(), HttpEntity$.MODULE$.fromPath$default$3());
        }
        if (bodyPart instanceof StreamBody) {
            StreamBody streamBody = (StreamBody)bodyPart;
            Object b = streamBody.b();
            return BodyToPekko$.streamPartEntity$1(ct, (Source)b, mp$1);
        }
        throw new MatchError((Object)bodyPart);
    }

    private static final Try toBodyPart$1(Part mp) {
        return Util$.MODULE$.parseContentTypeOrOctetStream((Option<String>)mp.contentType()).flatMap((Function1 & Serializable & scala.Serializable)ct -> ToPekko$.MODULE$.headers((Seq<Header>)mp.headers().toList()).map((Function1 & Serializable & scala.Serializable)headers -> Multipart.FormData$.BodyPart$.MODULE$.apply(mp.name(), BodyToPekko$.entity$1(ct, mp), mp.dispositionParams(), headers)));
    }

    private static final RequestEntity streamEntity$1(ContentType contentType, Source s, Option contentLength$1) {
        Option option = contentLength$1;
        if (None$.MODULE$.equals(option)) {
            return HttpEntity$.MODULE$.apply(contentType, s);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long l = BoxesRunTime.unboxToLong((Object)some.value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }

    private BodyToPekko$() {
        MODULE$ = this;
    }
}

