/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.jox;

import com.softwaremill.jox.ChannelClosed;
import com.softwaremill.jox.Continuation;
import com.softwaremill.jox.SelectClause;
import com.softwaremill.jox.SelectState;
import com.softwaremill.jox.StoredSelectClause;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.LockSupport;

class SelectInstance {
    private volatile Object state = SelectState.REGISTERING;
    private static final VarHandle STATE;
    private final List<StoredSelectClause> storedClauses;
    private Object resultSelectedDuringRegistration;

    SelectInstance(int clausesCount) {
        this.storedClauses = new ArrayList<StoredSelectClause>(clausesCount);
    }

    <U> boolean register(SelectClause<U> clause) {
        Object result = clause.register(this);
        if (result instanceof StoredSelectClause) {
            StoredSelectClause ss = (StoredSelectClause)result;
            this.storedClauses.add(ss);
            return true;
        }
        if (result instanceof ChannelClosed) {
            ChannelClosed cc = (ChannelClosed)result;
            this.state = cc;
            return false;
        }
        this.resultSelectedDuringRegistration = result;
        this.state = clause;
        return false;
    }

    Object checkStateAndWait(boolean allRendezvous) throws InterruptedException {
        Object currentState;
        block0: while (true) {
            SelectClause clause;
            Object currentThread;
            if ((currentState = this.state) == SelectState.REGISTERING) {
                int spinIterations;
                currentThread = Thread.currentThread();
                if (!STATE.compareAndSet(this, SelectState.REGISTERING, (Thread)currentThread)) continue;
                int n = spinIterations = allRendezvous ? Continuation.RENDEZVOUS_SPINS : 0;
                while (true) {
                    if (this.state != currentThread) continue block0;
                    if (spinIterations > 0) {
                        Thread.onSpinWait();
                        --spinIterations;
                        continue;
                    }
                    LockSupport.park();
                    if (!Thread.interrupted()) continue;
                    if (STATE.compareAndSet(this, (Thread)currentThread, SelectState.INTERRUPTED)) {
                        this.cleanup(null);
                        throw new InterruptedException();
                    }
                    Thread.currentThread().interrupt();
                }
            }
            if (!(currentState instanceof List)) break;
            if (!STATE.compareAndSet(this, currentState, SelectState.REGISTERING)) continue;
            currentThread = ((List)currentState).iterator();
            block2: do {
                if (!currentThread.hasNext()) continue block0;
                clause = (SelectClause)currentThread.next();
                Iterator<StoredSelectClause> storedSelectsIterator = this.storedClauses.iterator();
                while (storedSelectsIterator.hasNext()) {
                    StoredSelectClause stored = storedSelectsIterator.next();
                    if (stored.getClause() != clause) continue;
                    stored.cleanup();
                    storedSelectsIterator.remove();
                    continue block2;
                }
            } while (this.register(clause));
        }
        if (currentState instanceof SelectClause) {
            SelectClause selectedClause = (SelectClause)currentState;
            this.cleanup(selectedClause);
            return selectedClause.transformedRawValue(this.resultSelectedDuringRegistration);
        }
        if (currentState instanceof StoredSelectClause) {
            StoredSelectClause ss = (StoredSelectClause)currentState;
            SelectClause<?> selectedClause = ss.getClause();
            this.cleanup(selectedClause);
            return selectedClause.transformedRawValue(ss.getPayload());
        }
        if (currentState instanceof ChannelClosed) {
            ChannelClosed cc = (ChannelClosed)currentState;
            this.cleanup(null);
            return cc;
        }
        throw new IllegalStateException("Unknown state: " + String.valueOf(currentState));
    }

    private void cleanup(SelectClause<?> selected) {
        for (StoredSelectClause stored : this.storedClauses) {
            if (stored.getClause() == selected) continue;
            stored.cleanup();
        }
        this.storedClauses.clear();
    }

    boolean trySelect(StoredSelectClause storedSelectClause) {
        Object currentState;
        block7: {
            Thread t;
            while (true) {
                if ((currentState = this.state) == SelectState.REGISTERING) {
                    if (!STATE.compareAndSet(this, currentState, Collections.singletonList(storedSelectClause.getClause()))) continue;
                    return false;
                }
                if (currentState instanceof List) {
                    List clausesToReRegister = (List)currentState;
                    ArrayList newClausesToReRegister = new ArrayList(clausesToReRegister.size() + 1);
                    newClausesToReRegister.addAll(clausesToReRegister);
                    newClausesToReRegister.add(storedSelectClause.getClause());
                    if (!STATE.compareAndSet(this, currentState, newClausesToReRegister)) continue;
                    return false;
                }
                if (currentState instanceof SelectClause) {
                    return false;
                }
                if (currentState instanceof StoredSelectClause) {
                    return false;
                }
                if (!(currentState instanceof Thread)) break block7;
                t = (Thread)currentState;
                if (STATE.compareAndSet(this, currentState, storedSelectClause)) break;
            }
            LockSupport.unpark(t);
            return true;
        }
        if (currentState == SelectState.INTERRUPTED) {
            return false;
        }
        if (currentState instanceof ChannelClosed) {
            return false;
        }
        throw new IllegalStateException("Unknown state: " + String.valueOf(currentState));
    }

    /*
     * Unable to fully structure code
     */
    boolean channelClosed(ChannelClosed channelClosed) {
        block5: {
            do lbl-1000:
            // 4 sources

            {
                block7: {
                    block6: {
                        if ((currentState = this.state) != SelectState.REGISTERING) break block6;
                        if (!SelectInstance.STATE.compareAndSet(this, currentState, channelClosed)) ** GOTO lbl-1000
                        return true;
                    }
                    if (!(currentState instanceof List)) break block7;
                    if (!SelectInstance.STATE.compareAndSet(this, currentState, channelClosed)) ** GOTO lbl-1000
                    return true;
                }
                if (currentState instanceof SelectClause) {
                    return false;
                }
                if (currentState instanceof StoredSelectClause) {
                    return false;
                }
                if (!(currentState instanceof Thread)) break block5;
                t = (Thread)currentState;
            } while (!SelectInstance.STATE.compareAndSet(this, currentState, channelClosed));
            LockSupport.unpark(t);
            return true;
        }
        if (currentState == SelectState.INTERRUPTED) {
            return false;
        }
        if (currentState instanceof ChannelClosed) {
            return false;
        }
        throw new IllegalStateException("Unknown state: " + String.valueOf(currentState));
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.privateLookupIn(SelectInstance.class, MethodHandles.lookup());
            STATE = l.findVarHandle(SelectInstance.class, "state", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

