/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.jox;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

final class Segment {
    static final int SEGMENT_SIZE = 32;
    private static final int PROCESSED_SHIFT = 6;
    private static final int POINTERS_SHIFT = 12;
    static final Segment NULL_SEGMENT = new Segment(-1L, null, 0, false);
    private final long id;
    private final boolean isRendezvousOrUnlimited;
    private final Object[] data = new Object[32];
    private volatile Object next = null;
    private volatile Segment prev;
    private volatile int pointers_notProcessed_notInterrupted;
    private static final VarHandle DATA;
    private static final VarHandle NEXT;
    private static final VarHandle PREV;
    private static final VarHandle POINTERS_NOT_PROCESSED_NOT_INTERRUPTED;
    private static final int ONE_PROCESSED = 64;
    private static final int ONE_PROCESSED_AND_INTERRUPTED = 65;

    Segment(long id, Segment prev, int pointers, boolean isRendezvousOrUnlimited) {
        this.id = id;
        this.prev = prev;
        this.pointers_notProcessed_notInterrupted = 32 + (isRendezvousOrUnlimited ? 0 : 2048) + (pointers << 12);
        this.isRendezvousOrUnlimited = isRendezvousOrUnlimited;
    }

    long getId() {
        return this.id;
    }

    void cleanPrev() {
        this.prev = null;
    }

    Segment getNext() {
        Object s = this.next;
        return s == State.CLOSED ? null : (Segment)s;
    }

    Segment getPrev() {
        return this.prev;
    }

    private boolean setNextIfNull(Segment setTo) {
        return NEXT.compareAndSet(this, null, setTo);
    }

    Object getCell(int index) {
        return DATA.getVolatile(this.data, index);
    }

    void setCell(int index, Object value) {
        DATA.setVolatile(this.data, index, value);
    }

    boolean casCell(int index, Object expected, Object newValue) {
        return DATA.compareAndSet(this.data, index, expected, newValue);
    }

    private boolean isTail() {
        return this.getNext() == null;
    }

    boolean isRemoved() {
        return this.pointers_notProcessed_notInterrupted == 0;
    }

    boolean tryIncPointers() {
        int p;
        do {
            if ((p = this.pointers_notProcessed_notInterrupted) != 0) continue;
            return false;
        } while (!POINTERS_NOT_PROCESSED_NOT_INTERRUPTED.compareAndSet(this, p, p + 4096));
        return true;
    }

    boolean decPointers() {
        int currentP;
        boolean updated;
        int toAdd = -4096;
        while (!(updated = POINTERS_NOT_PROCESSED_NOT_INTERRUPTED.compareAndSet(this, currentP = this.pointers_notProcessed_notInterrupted, currentP + toAdd))) {
        }
        return currentP + toAdd == 0;
    }

    void cellInterruptedReceiver() {
        if (POINTERS_NOT_PROCESSED_NOT_INTERRUPTED.getAndAdd(this, -1) == 1) {
            this.remove();
        }
    }

    void cellInterruptedSender() {
        if (this.isRendezvousOrUnlimited) {
            if (POINTERS_NOT_PROCESSED_NOT_INTERRUPTED.getAndAdd(this, -1) == 1) {
                this.remove();
            }
        } else if (POINTERS_NOT_PROCESSED_NOT_INTERRUPTED.getAndAdd(this, -65) == 65) {
            this.remove();
        }
    }

    void cellProcessed_notInterruptedSender() {
        if (POINTERS_NOT_PROCESSED_NOT_INTERRUPTED.getAndAdd(this, -64) == 64) {
            this.remove();
        }
    }

    void setup_markCellsProcessed(int numberOfCells) {
        this.pointers_notProcessed_notInterrupted -= 64 * numberOfCells;
    }

    void remove() {
        Segment _prev;
        Segment _next;
        do {
            Segment currentPrevOfNext;
            if (this.isTail()) {
                return;
            }
            _prev = this.aliveSegmentLeft();
            _next = this.aliveSegmentRight();
            boolean prevOfNextUpdated = false;
            while (!(prevOfNextUpdated = (currentPrevOfNext = _next.prev) == null ? true : PREV.compareAndSet(_next, currentPrevOfNext, _prev))) {
            }
            if (_prev == null) continue;
            _prev.next = _next;
        } while (_next.isRemoved() && !_next.isTail() || _prev != null && _prev.isRemoved());
    }

    Segment close() {
        Segment s = this;
        while (true) {
            Object n;
            if ((n = s.next) == null) {
                if (!NEXT.compareAndSet(s, null, State.CLOSED)) continue;
                return s;
            }
            if (n == State.CLOSED) {
                return s;
            }
            s = (Segment)n;
        }
    }

    private Segment aliveSegmentLeft() {
        Segment s = this.prev;
        while (s != null && s.isRemoved()) {
            s = s.prev;
        }
        return s;
    }

    private Segment aliveSegmentRight() {
        Segment n = (Segment)this.next;
        while (n.isRemoved() && !n.isTail()) {
            n = (Segment)n.next;
        }
        return n;
    }

    static Segment findAndMoveForward(VarHandle segmentVarHandle, Object segmentThis, Segment start, long id) {
        Segment segment;
        do {
            if ((segment = Segment.findSegment(start, id)) != null) continue;
            return null;
        } while (!Segment.moveForward(segmentVarHandle, segmentThis, segment));
        return segment;
    }

    private static Segment findSegment(Segment start, long id) {
        Segment current = start;
        while (current.getId() < id || current.isRemoved()) {
            Object n = current.next;
            if (n == State.CLOSED) {
                return null;
            }
            if (n == null) {
                Segment newSegment = new Segment(current.getId() + 1L, current, 0, start.isRendezvousOrUnlimited);
                if (!current.setNextIfNull(newSegment) || !current.isRemoved()) continue;
                current.remove();
                continue;
            }
            current = (Segment)n;
        }
        return current;
    }

    private static boolean moveForward(VarHandle segmentVarHandle, Object segmentThis, Segment to) {
        Segment current;
        while ((current = segmentVarHandle.getVolatile(segmentThis)).getId() < to.getId()) {
            if (!to.tryIncPointers()) {
                return false;
            }
            if (segmentVarHandle.compareAndSet(segmentThis, current, to)) {
                if (current.decPointers()) {
                    current.remove();
                }
                return true;
            }
            if (!to.decPointers()) continue;
            to.remove();
        }
        return true;
    }

    public String toString() {
        Object n = this.next;
        Segment p = this.prev;
        int c = this.pointers_notProcessed_notInterrupted;
        int notInterrupted = c & 0x3F;
        int notProcessed = (c & 0xFFF) >> 6;
        int pointers = c >> 12;
        return "Segment{id=" + this.id + ", next=" + String.valueOf(n == null ? "null" : (n == State.CLOSED ? "closed" : Long.valueOf(((Segment)n).id))) + ", prev=" + String.valueOf(p == null ? "null" : Long.valueOf(p.id)) + ", pointers=" + pointers + ", notProcessed=" + notProcessed + ", notInterrupted=" + notInterrupted + "}";
    }

    void setNext(Segment newNext) {
        NEXT.set(this, newNext);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.privateLookupIn(Segment.class, MethodHandles.lookup());
            DATA = MethodHandles.arrayElementVarHandle(Object[].class);
            NEXT = l.findVarHandle(Segment.class, "next", Object.class);
            PREV = l.findVarHandle(Segment.class, "prev", Segment.class);
            POINTERS_NOT_PROCESSED_NOT_INTERRUPTED = l.findVarHandle(Segment.class, "pointers_notProcessed_notInterrupted", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static enum State {
        CLOSED;

    }
}

