/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.jox;

import com.softwaremill.jox.ChannelClosed;
import com.softwaremill.jox.RestartSelectMarker;
import com.softwaremill.jox.SelectClause;
import com.softwaremill.jox.Source;
import java.util.function.Function;

public class CollectSource<V, T>
implements Source<T> {
    private final Source<V> original;
    private final Function<V, T> f;

    public CollectSource(Source<V> original, Function<V, T> f) {
        this.original = original;
        this.f = f;
    }

    @Override
    public T receive() throws InterruptedException {
        V r;
        T t;
        while ((t = this.f.apply(r = this.original.receive())) == null) {
        }
        return t;
    }

    @Override
    public Object receiveOrClosed() throws InterruptedException {
        Object r;
        T t;
        do {
            if (!((r = this.original.receiveOrClosed()) instanceof ChannelClosed)) continue;
            ChannelClosed c = (ChannelClosed)r;
            return c;
        } while ((t = this.f.apply(r)) == null);
        return t;
    }

    @Override
    public SelectClause<T> receiveClause() {
        return this.original.receiveClause(v -> {
            T t = this.f.apply(v);
            if (t != null) {
                return t;
            }
            return RestartSelectMarker.RESTART;
        });
    }

    @Override
    public <U> SelectClause<U> receiveClause(Function<T, U> callback) {
        return this.original.receiveClause(v -> {
            T t = this.f.apply(v);
            if (t != null) {
                return callback.apply(t);
            }
            return RestartSelectMarker.RESTART;
        });
    }

    @Override
    public void done() {
        this.original.done();
    }

    @Override
    public Object doneOrClosed() {
        return this.original.doneOrClosed();
    }

    @Override
    public void error(Throwable reason) {
        this.original.error(reason);
    }

    @Override
    public Object errorOrClosed(Throwable reason) {
        return this.original.errorOrClosed(reason);
    }

    @Override
    public ChannelClosed closedForSend() {
        return this.original.closedForSend();
    }

    @Override
    public ChannelClosed closedForReceive() {
        return this.original.closedForReceive();
    }
}

