/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.w3c.dom.Element;

public class PdfBoxLinkManager {
    private final Map<PDPage, Set<String>> _linkTargetAreas;
    private final SharedContext _sharedContext;
    private final float _dotsPerPoint;
    private final Box _root;
    private final PdfBoxOutputDevice _od;
    private final List _links;

    public PdfBoxLinkManager(SharedContext ctx, float dotsPerPoint, Box root, PdfBoxOutputDevice od) {
        this._sharedContext = ctx;
        this._dotsPerPoint = dotsPerPoint;
        this._root = root;
        this._od = od;
        this._linkTargetAreas = new HashMap<PDPage, Set<String>>();
        this._links = new ArrayList();
    }

    private Rectangle2D calcTotalLinkArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform) {
        Box prev;
        Box current = box;
        while ((prev = current.getPreviousSibling()) != null && prev.getElement() == box.getElement()) {
            current = prev;
        }
        Rectangle2D result = PdfBoxLinkManager.createTargetArea(c, current, pageHeight, transform, this._root, this._od);
        for (current = current.getNextSibling(); current != null && current.getElement() == box.getElement(); current = current.getNextSibling()) {
            result = this.add(result, PdfBoxLinkManager.createTargetArea(c, current, pageHeight, transform, this._root, this._od));
        }
        return result;
    }

    private Rectangle2D add(Rectangle2D r1, Rectangle2D r2) {
        float llx = (float)Math.min(r1.getMinX(), r2.getMinX());
        float urx = (float)Math.max(r1.getMaxX(), r2.getMaxX());
        float lly = (float)Math.min(r1.getMaxY(), r2.getMaxY());
        float ury = (float)Math.max(r1.getMinY(), r2.getMinY());
        return new Rectangle2D.Float(llx, lly, urx, ury);
    }

    private String createRectKey(Rectangle2D rect) {
        return rect.getMinX() + ":" + rect.getMaxY() + ":" + rect.getMaxX() + ":" + rect.getMinY();
    }

    private Rectangle2D checkLinkArea(PDPage page, RenderingContext c, Box box, float pageHeight, AffineTransform transform) {
        Rectangle2D targetArea = this.calcTotalLinkArea(c, box, pageHeight, transform);
        String key = this.createRectKey(targetArea);
        Set<String> keys = this._linkTargetAreas.get(page);
        if (keys == null) {
            keys = new HashSet<String>();
            this._linkTargetAreas.put(page, keys);
        }
        if (keys.contains(key)) {
            return null;
        }
        keys.add(key);
        return targetArea;
    }

    public void processLink(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform) {
        NamespaceHandler handler;
        String uri;
        Element elem = box.getElement();
        if (elem != null && (uri = (handler = this._sharedContext.getNamespaceHandler()).getLinkUri(elem)) != null) {
            if (uri.length() > 1 && uri.charAt(0) == '#') {
                String anchor = uri.substring(1);
                Box target = this._sharedContext.getBoxById(anchor);
                if (target != null) {
                    PDActionGoTo action;
                    PDPageXYZDestination dest = this.createDestination(c, target);
                    if (handler.getAttributeValue(elem, "onclick") != null && !"".equals(handler.getAttributeValue(elem, "onclick"))) {
                        action = new PDActionJavaScript(handler.getAttributeValue(elem, "onclick"));
                    } else {
                        PDActionGoTo go = new PDActionGoTo();
                        go.setDestination((PDDestination)dest);
                        action = go;
                    }
                    Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform);
                    if (targetArea == null) {
                        return;
                    }
                    PDAnnotationLink annot = new PDAnnotationLink();
                    annot.setAction((PDAction)action);
                    annot.setRectangle(new PDRectangle((float)targetArea.getMinX(), (float)targetArea.getMinY(), (float)targetArea.getWidth(), (float)targetArea.getHeight()));
                    PDBorderStyleDictionary styleDict = new PDBorderStyleDictionary();
                    styleDict.setWidth(0.0f);
                    styleDict.setStyle("S");
                    annot.setBorderStyle(styleDict);
                    try {
                        ArrayList<PDAnnotationLink> annots = page.getAnnotations();
                        if (annots == null) {
                            annots = new ArrayList<PDAnnotationLink>();
                            page.setAnnotations(annots);
                        }
                        annots.add(annot);
                    }
                    catch (IOException e) {
                        throw new PdfContentStreamAdapter.PdfException("processLink", e);
                    }
                }
            } else if (uri.indexOf("://") != -1) {
                PDActionURI uriAct = new PDActionURI();
                uriAct.setURI(uri);
                Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform);
                if (targetArea == null) {
                    return;
                }
                PDAnnotationLink annot = new PDAnnotationLink();
                annot.setAction((PDAction)uriAct);
                annot.setRectangle(new PDRectangle((float)targetArea.getMinX(), (float)targetArea.getMinY(), (float)targetArea.getWidth(), (float)targetArea.getHeight()));
                PDBorderStyleDictionary styleDict = new PDBorderStyleDictionary();
                styleDict.setWidth(0.0f);
                styleDict.setStyle("S");
                annot.setBorderStyle(styleDict);
                try {
                    page.getAnnotations().add(annot);
                }
                catch (IOException e) {
                    throw new PdfContentStreamAdapter.PdfException("processLink", e);
                }
            }
        }
    }

    private PDPageXYZDestination createDestination(RenderingContext c, Box box) {
        PDPageXYZDestination result = new PDPageXYZDestination();
        PageBox page = this._root.getLayer().getPage((CssContext)c, this._od.getPageRefY(box));
        int distanceFromTop = page.getMarginBorderPadding((CssContext)c, 3);
        distanceFromTop = (int)((float)distanceFromTop + ((float)box.getAbsY() + box.getMargin((CssContext)c).top() - (float)page.getTop()));
        result.setTop((int)((float)page.getHeight((CssContext)c) / this._dotsPerPoint - (float)distanceFromTop / this._dotsPerPoint));
        result.setPage(this._od.getWriter().getPage(this._od.getStartPageNo() + page.getPageNo()));
        return result;
    }

    public static Rectangle2D createTargetArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform, Box _root, PdfBoxOutputDevice _od) {
        Rectangle bounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), (CssContext)c);
        PageBox page = _root.getLayer().getPage((CssContext)c, bounds.y);
        float bottom = _od.getDeviceLength(page.getBottom() - (bounds.y + bounds.height) + page.getMarginBorderPadding((CssContext)c, 4));
        float left = _od.getDeviceLength(page.getMarginBorderPadding((CssContext)c, 1) + bounds.x);
        Rectangle2D.Float result = new Rectangle2D.Float(left, bottom, _od.getDeviceLength(bounds.width), _od.getDeviceLength(bounds.height));
        return result;
    }

    public void processLinkLater(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform) {
        LinkDetails link = new LinkDetails();
        link.c = c;
        link.box = box;
        link.page = page;
        link.pageHeight = pageHeight;
        link.transform = transform;
        this._links.add(link);
    }

    public void processLinks() {
        for (int i = 0; i < this._links.size(); ++i) {
            LinkDetails link = (LinkDetails)this._links.get(i);
            this.processLink(link.c, link.box, link.page, link.pageHeight, link.transform);
        }
    }

    public static class LinkDetails {
        RenderingContext c;
        Box box;
        PDPage page;
        float pageHeight;
        AffineTransform transform;
    }
}

