/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.Serializable;
import scala.Byte$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Short$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import ujson.Arr;
import ujson.Arr$;
import ujson.AstTransformer;
import ujson.Bool;
import ujson.False$;
import ujson.Null$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Str;
import ujson.Str$;
import ujson.True$;
import ujson.Value;
import ujson.Value$InvalidData$;
import ujson.Value$Selector$;
import upickle.core.ArrVisitor;
import upickle.core.LinkedHashMap;
import upickle.core.LinkedHashMap$;
import upickle.core.ObjVisitor;
import upickle.core.ParseUtils$;
import upickle.core.Visitor;
import upickle.core.compat.package$;

public final class Value$
implements AstTransformer<Value>,
Mirror.Sum {
    public static final Value$Selector$ Selector;
    public static final Value$InvalidData$ InvalidData;
    public static final Value$ MODULE$;

    private Value$() {
    }

    static {
        MODULE$ = new Value$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Value$.class);
    }

    public <T> Arr JsonableSeq(IterableOnce<T> items, Function1<T, Value> f) {
        return Arr$.MODULE$.from(package$.MODULE$.toIterator(items).map(f), Predef$.MODULE$.$conforms());
    }

    public <T> Obj JsonableDict(IterableOnce<Tuple2<String, T>> items, Function1<T, Value> f) {
        return Obj$.MODULE$.from((IterableOnce<Tuple2<String, Value>>)package$.MODULE$.toIterator(items).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), f.apply(x._2()))));
    }

    public Bool JsonableBoolean(boolean i) {
        return i ? True$.MODULE$ : False$.MODULE$;
    }

    public Num JsonableByte(byte i) {
        return Num$.MODULE$.apply(Byte$.MODULE$.byte2double(i));
    }

    public Num JsonableShort(short i) {
        return Num$.MODULE$.apply(Short$.MODULE$.short2double(i));
    }

    public Num JsonableInt(int i) {
        return Num$.MODULE$.apply(Int$.MODULE$.int2double(i));
    }

    public Str JsonableLong(long i) {
        return Str$.MODULE$.apply(BoxesRunTime.boxToLong((long)i).toString());
    }

    public Num JsonableFloat(float i) {
        return Num$.MODULE$.apply(Float$.MODULE$.float2double(i));
    }

    public Num JsonableDouble(double i) {
        return Num$.MODULE$.apply(i);
    }

    public Null$ JsonableNull(scala.runtime.Null$ i) {
        return Null$.MODULE$;
    }

    public Str JsonableString(CharSequence s) {
        return Str$.MODULE$.apply(s.toString());
    }

    public <T> T transform(Value j, Visitor<?, T> f) {
        Value value = j;
        if (Null$.MODULE$.equals(value)) {
            return (T)f.visitNull(-1);
        }
        if (True$.MODULE$.equals(value)) {
            return (T)f.visitTrue(-1);
        }
        if (False$.MODULE$.equals(value)) {
            return (T)f.visitFalse(-1);
        }
        if (value instanceof Str) {
            String string;
            Str str = Str$.MODULE$.unapply((Str)value);
            String s = string = str._1();
            return (T)f.visitString((CharSequence)s, -1);
        }
        if (value instanceof Num) {
            double d;
            Num num = Num$.MODULE$.unapply((Num)value);
            double d2 = d = num._1();
            return (T)f.visitFloat64(d2, -1);
        }
        if (value instanceof Arr) {
            ArrayBuffer<Value> arrayBuffer;
            Arr arr = Arr$.MODULE$.unapply((Arr)value);
            ArrayBuffer<Value> items = arrayBuffer = arr._1();
            return (T)this.transformArray((Visitor)f, (Iterable)items);
        }
        if (value instanceof Obj) {
            LinkedHashMap<String, Value> linkedHashMap;
            Obj obj = Obj$.MODULE$.unapply((Obj)value);
            LinkedHashMap<String, Value> items = linkedHashMap = obj._1();
            return (T)this.transformObject((Visitor)f, (Iterable)items);
        }
        throw new MatchError((Object)value);
    }

    public ArrVisitor<Value, Value> visitArray(int length, int index) {
        return new AstTransformer.AstArrVisitor(this, (Function1 & Serializable)xs -> Arr$.MODULE$.apply((ArrayBuffer<Value>)xs), ArrayBuffer$.MODULE$.iterableFactory());
    }

    @Override
    public ObjVisitor<Value, Value> visitJsonableObject(int length, int index) {
        return new AstTransformer.AstObjVisitor(this, (Function1 & Serializable)xs -> Obj$.MODULE$.apply((LinkedHashMap<String, Value>)xs), LinkedHashMap$.MODULE$.factory());
    }

    public Value visitNull(int index) {
        return Null$.MODULE$;
    }

    public Value visitFalse(int index) {
        return False$.MODULE$;
    }

    public Value visitTrue(int index) {
        return True$.MODULE$;
    }

    public Value visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        return Num$.MODULE$.apply(decIndex != -1 || expIndex != -1 || s.length() >= 19 ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s.toString())) : (double)ParseUtils$.MODULE$.parseIntegralNum(s, decIndex, expIndex, index));
    }

    @Override
    public Value visitFloat64(double d, int index) {
        return Num$.MODULE$.apply(d);
    }

    public Value visitString(CharSequence s, int index) {
        return Str$.MODULE$.apply(s.toString());
    }

    public int ordinal(Value x$0) {
        Value value = x$0;
        if (value instanceof Str) {
            return 0;
        }
        if (value instanceof Obj) {
            return 1;
        }
        if (value instanceof Arr) {
            return 2;
        }
        if (value instanceof Num) {
            return 3;
        }
        if (value instanceof Bool) {
            return 4;
        }
        if (value == Null$.MODULE$) {
            return 5;
        }
        throw new MatchError((Object)value);
    }
}

