/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.Writer;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import ujson.BaseCharRenderer$;
import ujson.DoubleToDecimalChar$;
import ujson.FloatToDecimalChar$;
import ujson.JsVisitor;
import upickle.core.ArrVisitor;
import upickle.core.CharBuilder;
import upickle.core.CharBuilder$;
import upickle.core.ObjVisitor;
import upickle.core.RenderUtils$;
import upickle.core.Visitor;

public class BaseCharRenderer<T extends Writer>
implements JsVisitor<T, T> {
    public final T ujson$BaseCharRenderer$$out;
    public final int ujson$BaseCharRenderer$$indent;
    private final boolean escapeUnicode;
    public final CharBuilder ujson$BaseCharRenderer$$charBuilder;
    private final CharBuilder unicodeCharBuilder;
    public int ujson$BaseCharRenderer$$depth;
    public boolean ujson$BaseCharRenderer$$visitingKey;
    public boolean ujson$BaseCharRenderer$$commaBuffered;
    public boolean ujson$BaseCharRenderer$$indentBuffered;
    public boolean ujson$BaseCharRenderer$$quoteBuffered;

    public static <T extends Writer> int $lessinit$greater$default$2() {
        return BaseCharRenderer$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T extends Writer> boolean $lessinit$greater$default$3() {
        return BaseCharRenderer$.MODULE$.$lessinit$greater$default$3();
    }

    public BaseCharRenderer(T out, int indent, boolean escapeUnicode) {
        this.ujson$BaseCharRenderer$$out = out;
        this.ujson$BaseCharRenderer$$indent = indent;
        this.escapeUnicode = escapeUnicode;
        this.ujson$BaseCharRenderer$$charBuilder = new CharBuilder(CharBuilder$.MODULE$.$lessinit$greater$default$1());
        this.unicodeCharBuilder = new CharBuilder(CharBuilder$.MODULE$.$lessinit$greater$default$1());
        this.ujson$BaseCharRenderer$$depth = 0;
        this.ujson$BaseCharRenderer$$visitingKey = false;
        this.ujson$BaseCharRenderer$$commaBuffered = false;
        this.ujson$BaseCharRenderer$$indentBuffered = false;
        this.ujson$BaseCharRenderer$$quoteBuffered = false;
    }

    public void flushCharBuilder() {
        this.ujson$BaseCharRenderer$$charBuilder.writeOutToIfLongerThan(this.ujson$BaseCharRenderer$$out, this.ujson$BaseCharRenderer$$depth == 0 ? 0 : 1000);
    }

    public void flushBuffer() {
        if (this.ujson$BaseCharRenderer$$commaBuffered) {
            this.ujson$BaseCharRenderer$$commaBuffered = false;
            this.ujson$BaseCharRenderer$$charBuilder.append(',');
        }
        if (this.ujson$BaseCharRenderer$$indentBuffered) {
            this.ujson$BaseCharRenderer$$indentBuffered = false;
            this.renderIndent();
        }
        if (this.ujson$BaseCharRenderer$$quoteBuffered) {
            this.ujson$BaseCharRenderer$$quoteBuffered = false;
            this.ujson$BaseCharRenderer$$charBuilder.append('\"');
            return;
        }
    }

    public ArrVisitor<T, T> visitArray(int length, int index) {
        return new ArrVisitor<T, T>(this){
            private final /* synthetic */ BaseCharRenderer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                $outer.flushBuffer();
                $outer.ujson$BaseCharRenderer$$charBuilder.append('[');
                ++$outer.ujson$BaseCharRenderer$$depth;
                $outer.ujson$BaseCharRenderer$$indentBuffered = true;
            }

            public Visitor subVisitor() {
                return this.$outer;
            }

            public void visitValue(Writer v, int index) {
                this.$outer.flushBuffer();
                this.$outer.ujson$BaseCharRenderer$$commaBuffered = true;
                this.$outer.ujson$BaseCharRenderer$$indentBuffered = true;
            }

            public Writer visitEnd(int index) {
                --this.$outer.ujson$BaseCharRenderer$$depth;
                if (this.$outer.ujson$BaseCharRenderer$$indentBuffered && this.$outer.ujson$BaseCharRenderer$$commaBuffered) {
                    this.$outer.renderIndent();
                }
                this.$outer.ujson$BaseCharRenderer$$commaBuffered = false;
                this.$outer.ujson$BaseCharRenderer$$indentBuffered = false;
                this.$outer.ujson$BaseCharRenderer$$charBuilder.append(']');
                this.$outer.flushCharBuilder();
                return this.$outer.ujson$BaseCharRenderer$$out;
            }
        };
    }

    @Override
    public ObjVisitor<T, T> visitJsonableObject(int length, int index) {
        return new ObjVisitor<T, T>(this){
            private final /* synthetic */ BaseCharRenderer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                $outer.flushBuffer();
                $outer.ujson$BaseCharRenderer$$charBuilder.append('{');
                ++$outer.ujson$BaseCharRenderer$$depth;
                $outer.ujson$BaseCharRenderer$$indentBuffered = true;
            }

            public Visitor subVisitor() {
                return this.$outer;
            }

            public Visitor visitKey(int index) {
                this.$outer.ujson$BaseCharRenderer$$quoteBuffered = true;
                this.$outer.ujson$BaseCharRenderer$$visitingKey = true;
                return this.$outer;
            }

            public void visitKeyValue(Object s) {
                this.$outer.ujson$BaseCharRenderer$$charBuilder.append('\"');
                this.$outer.ujson$BaseCharRenderer$$visitingKey = false;
                this.$outer.ujson$BaseCharRenderer$$charBuilder.append(':');
                if (this.$outer.ujson$BaseCharRenderer$$indent != -1) {
                    this.$outer.ujson$BaseCharRenderer$$charBuilder.append(' ');
                    return;
                }
            }

            public void visitValue(Writer v, int index) {
                this.$outer.ujson$BaseCharRenderer$$commaBuffered = true;
                this.$outer.ujson$BaseCharRenderer$$indentBuffered = true;
            }

            public Writer visitEnd(int index) {
                --this.$outer.ujson$BaseCharRenderer$$depth;
                if (this.$outer.ujson$BaseCharRenderer$$indentBuffered && this.$outer.ujson$BaseCharRenderer$$commaBuffered) {
                    this.$outer.renderIndent();
                }
                this.$outer.ujson$BaseCharRenderer$$commaBuffered = false;
                this.$outer.ujson$BaseCharRenderer$$indentBuffered = false;
                this.$outer.ujson$BaseCharRenderer$$charBuilder.append('}');
                this.$outer.flushCharBuilder();
                return this.$outer.ujson$BaseCharRenderer$$out;
            }
        };
    }

    public T visitNull(int index) {
        this.flushBuffer();
        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendNull(this.ujson$BaseCharRenderer$$charBuilder);
        this.flushCharBuilder();
        return this.ujson$BaseCharRenderer$$out;
    }

    public T visitFalse(int index) {
        this.flushBuffer();
        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendFalse(this.ujson$BaseCharRenderer$$charBuilder);
        this.flushCharBuilder();
        return this.ujson$BaseCharRenderer$$out;
    }

    public T visitTrue(int index) {
        this.flushBuffer();
        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendTrue(this.ujson$BaseCharRenderer$$charBuilder);
        this.flushCharBuilder();
        return this.ujson$BaseCharRenderer$$out;
    }

    public T visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        this.flushBuffer();
        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendKnownAsciiString(this.ujson$BaseCharRenderer$$charBuilder, s);
        this.flushCharBuilder();
        return this.ujson$BaseCharRenderer$$out;
    }

    @Override
    public T visitFloat32(float d, int index) {
        Object object;
        float f = d;
        if (Float.POSITIVE_INFINITY == f) {
            object = this.visitNonNullString("Infinity", -1);
        } else if (Float.NEGATIVE_INFINITY == f) {
            object = this.visitNonNullString("-Infinity", -1);
        } else {
            float d2 = f;
            if (Float.isNaN(d2)) {
                object = this.visitNonNullString("NaN", -1);
            } else {
                float d3 = f;
                int i = (int)d3;
                if (d3 == (float)i) {
                    object = this.visitInt32(i, index);
                } else {
                    long i2 = (long)d3;
                    this.flushBuffer();
                    if ((float)i2 == d3) {
                        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendKnownAsciiString(this.ujson$BaseCharRenderer$$charBuilder, BoxesRunTime.boxToFloat((float)d3).toString());
                    } else {
                        this.ujson$BaseCharRenderer$$charBuilder.ensureLength(15);
                        this.ujson$BaseCharRenderer$$charBuilder.length_$eq(this.ujson$BaseCharRenderer$$charBuilder.length() + FloatToDecimalChar$.MODULE$.toString(this.ujson$BaseCharRenderer$$charBuilder.arr(), this.ujson$BaseCharRenderer$$charBuilder.length(), d3));
                    }
                    this.flushCharBuilder();
                    object = BoxedUnit.UNIT;
                }
            }
        }
        return this.ujson$BaseCharRenderer$$out;
    }

    @Override
    public T visitFloat64(double d, int index) {
        Object object;
        double d2 = d;
        if (Double.POSITIVE_INFINITY == d2) {
            object = this.visitNonNullString("Infinity", -1);
        } else if (Double.NEGATIVE_INFINITY == d2) {
            object = this.visitNonNullString("-Infinity", -1);
        } else {
            double d3 = d2;
            if (Double.isNaN(d3)) {
                object = this.visitNonNullString("NaN", -1);
            } else {
                double d4 = d2;
                int i = (int)d4;
                if (d4 == (double)i) {
                    object = this.visitInt32(i, index);
                } else {
                    long i2 = (long)d4;
                    this.flushBuffer();
                    if ((double)i2 == d4) {
                        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendKnownAsciiString(this.ujson$BaseCharRenderer$$charBuilder, BoxesRunTime.boxToLong((long)i2).toString());
                    } else {
                        this.ujson$BaseCharRenderer$$charBuilder.ensureLength(24);
                        this.ujson$BaseCharRenderer$$charBuilder.length_$eq(this.ujson$BaseCharRenderer$$charBuilder.length() + DoubleToDecimalChar$.MODULE$.toString(this.ujson$BaseCharRenderer$$charBuilder.arr(), this.ujson$BaseCharRenderer$$charBuilder.length(), d4));
                    }
                    this.flushCharBuilder();
                    object = BoxedUnit.UNIT;
                }
            }
        }
        return this.ujson$BaseCharRenderer$$out;
    }

    @Override
    public T visitInt32(int i, int index) {
        this.flushBuffer();
        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendIntString(this.ujson$BaseCharRenderer$$charBuilder, i);
        this.flushCharBuilder();
        return this.ujson$BaseCharRenderer$$out;
    }

    @Override
    public T visitInt64(long i, int index) {
        this.flushBuffer();
        if (package$.MODULE$.abs(i) > 0x20000000000000L || i == Long.MIN_VALUE) {
            this.ujson$BaseCharRenderer$$charBuilder.append('\"');
            BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendLongString(this.ujson$BaseCharRenderer$$charBuilder, i);
            this.ujson$BaseCharRenderer$$charBuilder.append('\"');
        } else {
            BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$appendLongString(this.ujson$BaseCharRenderer$$charBuilder, i);
        }
        this.flushCharBuilder();
        return this.ujson$BaseCharRenderer$$out;
    }

    @Override
    public T visitUInt64(long i, int index) {
        int n = (int)i;
        Object object = (long)n == i ? this.visitInt32(n, index) : (Writer)JsVisitor.visitUInt64$(this, i, index);
        return this.ujson$BaseCharRenderer$$out;
    }

    public T visitString(CharSequence s, int index) {
        if (s == null) {
            return (T)this.visitNull(index);
        }
        return this.visitNonNullString(s, index);
    }

    public T visitNonNullString(CharSequence s, int index) {
        this.flushBuffer();
        RenderUtils$.MODULE$.escapeChar(this.unicodeCharBuilder, this.ujson$BaseCharRenderer$$charBuilder, s, this.escapeUnicode, !this.ujson$BaseCharRenderer$$visitingKey);
        this.flushCharBuilder();
        return this.ujson$BaseCharRenderer$$out;
    }

    public final void renderIndent() {
        if (this.ujson$BaseCharRenderer$$indent == -1) {
            return;
        }
        int i = this.ujson$BaseCharRenderer$$indent * this.ujson$BaseCharRenderer$$depth;
        this.ujson$BaseCharRenderer$$charBuilder.ensureLength(i + 1);
        BaseCharRenderer$.MODULE$.ujson$BaseCharRenderer$$$renderIdent(this.ujson$BaseCharRenderer$$charBuilder.arr(), this.ujson$BaseCharRenderer$$charBuilder.length(), i);
        this.ujson$BaseCharRenderer$$charBuilder.length_$eq(this.ujson$BaseCharRenderer$$charBuilder.length() + (i + 1));
    }
}

