/*
 * Decompiled with CFR 0.152.
 */
package akka.grpc.javadsl;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.grpc.GrpcProtocol;
import akka.grpc.GrpcServiceException;
import akka.grpc.Trailers;
import akka.grpc.Trailers$;
import akka.grpc.internal.GrpcMetadataImpl;
import akka.grpc.internal.GrpcResponseHelpers$;
import akka.grpc.internal.MissingParameterException;
import akka.http.javadsl.model.HttpResponse;
import akka.japi.Function;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import scala.NotImplementedError;

@ApiMayChange
public final class GrpcExceptionHandler$ {
    public static GrpcExceptionHandler$ MODULE$;
    private final Trailers akka$grpc$javadsl$GrpcExceptionHandler$$INTERNAL;
    private final Trailers akka$grpc$javadsl$GrpcExceptionHandler$$INVALID_ARGUMENT;

    static {
        new GrpcExceptionHandler$();
    }

    public Trailers akka$grpc$javadsl$GrpcExceptionHandler$$INTERNAL() {
        return this.akka$grpc$javadsl$GrpcExceptionHandler$$INTERNAL;
    }

    public Trailers akka$grpc$javadsl$GrpcExceptionHandler$$INVALID_ARGUMENT() {
        return this.akka$grpc$javadsl$GrpcExceptionHandler$$INVALID_ARGUMENT;
    }

    public Function<ActorSystem, Function<Throwable, Trailers>> defaultMapper() {
        return new Function<ActorSystem, Function<Throwable, Trailers>>(){

            public Function<Throwable, Trailers> apply(ActorSystem system) {
                return GrpcExceptionHandler$.MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$default(system);
            }
        };
    }

    @InternalApi
    public Function<Throwable, Trailers> akka$grpc$javadsl$GrpcExceptionHandler$$default(ActorSystem system) {
        return new Function<Throwable, Trailers>(system){
            private final ActorSystem system$1;

            public Trailers apply(Throwable param) {
                Throwable throwable = param;
                if (throwable instanceof ExecutionException) {
                    ExecutionException executionException = (ExecutionException)throwable;
                    if (executionException.getCause() == null) {
                        return GrpcExceptionHandler$.MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$INTERNAL();
                    }
                    return (Trailers)GrpcExceptionHandler$.MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$default(this.system$1).apply((Object)executionException.getCause());
                }
                if (throwable instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)throwable;
                    if (completionException.getCause() == null) {
                        return GrpcExceptionHandler$.MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$INTERNAL();
                    }
                    return (Trailers)GrpcExceptionHandler$.MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$default(this.system$1).apply((Object)completionException.getCause());
                }
                if (throwable instanceof GrpcServiceException) {
                    GrpcServiceException grpcServiceException = (GrpcServiceException)((Object)throwable);
                    return Trailers$.MODULE$.apply(grpcServiceException.status(), grpcServiceException.metadata());
                }
                if (throwable instanceof MissingParameterException) {
                    return GrpcExceptionHandler$.MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$INVALID_ARGUMENT();
                }
                if (throwable instanceof NotImplementedError) {
                    NotImplementedError notImplementedError = (NotImplementedError)throwable;
                    return Trailers$.MODULE$.apply(Status.UNIMPLEMENTED.withDescription(notImplementedError.getMessage()));
                }
                if (throwable instanceof UnsupportedOperationException) {
                    UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                    return Trailers$.MODULE$.apply(Status.UNIMPLEMENTED.withDescription(unsupportedOperationException.getMessage()));
                }
                if (throwable instanceof StatusRuntimeException) {
                    StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
                    return Trailers$.MODULE$.apply(statusRuntimeException.getStatus(), new GrpcMetadataImpl(statusRuntimeException.getTrailers()));
                }
                LoggingAdapter log = Logging$.MODULE$.apply(this.system$1, (Object)"akka.grpc.javadsl.GrpcExceptionHandler", LogSource$.MODULE$.fromString());
                log.error(throwable, "Unhandled error: [{}]", (Object)throwable.getMessage());
                return GrpcExceptionHandler$.MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$INTERNAL();
            }
            {
                this.system$1 = system$1;
            }
        };
    }

    public HttpResponse standard(Throwable t, GrpcProtocol.GrpcProtocolWriter writer, ClassicActorSystemProvider system2) {
        return this.standard(t, (Function<ActorSystem, Function<Throwable, Trailers>>)((Function)system -> MODULE$.akka$grpc$javadsl$GrpcExceptionHandler$$default((ActorSystem)system)), writer, system2);
    }

    public HttpResponse standard(Throwable t, Function<ActorSystem, Function<Throwable, Trailers>> mapper, GrpcProtocol.GrpcProtocolWriter writer, ClassicActorSystemProvider system) {
        return GrpcResponseHelpers$.MODULE$.status((Trailers)((Function)mapper.apply((Object)system.classicSystem())).apply((Object)t), writer);
    }

    private GrpcExceptionHandler$() {
        MODULE$ = this;
        this.akka$grpc$javadsl$GrpcExceptionHandler$$INTERNAL = Trailers$.MODULE$.apply(Status.INTERNAL);
        this.akka$grpc$javadsl$GrpcExceptionHandler$$INVALID_ARGUMENT = Trailers$.MODULE$.apply(Status.INVALID_ARGUMENT);
    }
}

