/*
 * Decompiled with CFR 0.152.
 */
package akka.grpc;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.annotation.InternalApi;
import akka.discovery.Discovery;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.grpc.GrpcClientSettings;
import akka.grpc.SSLContextUtils$;
import akka.grpc.internal.HardcodedServiceDiscovery;
import akka.util.Helpers$;
import akka.util.JavaDurationConverters;
import akka.util.JavaDurationConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import io.grpc.CallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public final class GrpcClientSettings$ {
    public static GrpcClientSettings$ MODULE$;

    static {
        new GrpcClientSettings$();
    }

    private Function1<NettyChannelBuilder, NettyChannelBuilder> $lessinit$greater$default$18() {
        return (Function1 & Serializable & scala.Serializable)x -> (NettyChannelBuilder)Predef$.MODULE$.identity(x);
    }

    public GrpcClientSettings connectToServiceAt(String host, int port, ClassicActorSystemProvider actorSystem) {
        ActorSystem system = actorSystem.classicSystem();
        Config defaultServiceConfig = system.settings().config().getConfig("akka.grpc.client").getConfig("\"*\"").withValue("host", ConfigValueFactory.fromAnyRef((Object)host)).withValue("port", ConfigValueFactory.fromAnyRef((Object)BoxesRunTime.boxToInteger((int)port)));
        return this.fromConfig(defaultServiceConfig, actorSystem);
    }

    public GrpcClientSettings fromConfig(String clientName, ClassicActorSystemProvider actorSystem) {
        ActorSystem system = actorSystem.classicSystem();
        Config akkaGrpcClientConfig = system.settings().config().getConfig("akka.grpc.client");
        Config defaultServiceConfig = akkaGrpcClientConfig.getConfig("\"*\"");
        Predef$.MODULE$.require(akkaGrpcClientConfig.hasPath(new StringBuilder(2).append("\"").append(clientName).append("\"").toString()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Config path `akka.grpc.client.").append(clientName).append("` does not exist").toString());
        Config clientConfig = akkaGrpcClientConfig.getConfig(new StringBuilder(2).append("\"").append(clientName).append("\"").toString()).withFallback((ConfigMergeable)defaultServiceConfig);
        return this.fromConfig(clientConfig, actorSystem);
    }

    public GrpcClientSettings usingServiceDiscovery(String serviceName, ClassicActorSystemProvider actorSystem) {
        Config clientConfiguration = actorSystem.classicSystem().settings().config().getConfig("akka.grpc.client").getConfig("\"*\"");
        FiniteDuration resolveTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(clientConfiguration.getDuration("service-discovery.resolve-timeout")));
        ServiceDiscovery discovery = Discovery$.MODULE$.get(actorSystem).discovery();
        return this.withConfigDefaults(serviceName, discovery, -1, resolveTimeout, clientConfiguration);
    }

    public GrpcClientSettings usingServiceDiscovery(String serviceName, ServiceDiscovery discovery, ClassicActorSystemProvider actorSystem) {
        Config clientConfiguration = actorSystem.classicSystem().settings().config().getConfig("akka.grpc.client").getConfig("\"*\"");
        FiniteDuration resolveTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(clientConfiguration.getDuration("service-discovery.resolve-timeout")));
        return this.withConfigDefaults(serviceName, discovery, -1, resolveTimeout, clientConfiguration);
    }

    public GrpcClientSettings fromConfig(Config clientConfiguration, ClassicActorSystemProvider sys) {
        ServiceDiscovery serviceDiscovery;
        String serviceDiscoveryMechanism = clientConfiguration.getString("service-discovery.mechanism");
        String serviceName = clientConfiguration.getString("service-discovery.service-name");
        int port = clientConfiguration.getInt("port");
        FiniteDuration resolveTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(clientConfiguration.getDuration("service-discovery.resolve-timeout")));
        String string = serviceDiscoveryMechanism;
        if ("static".equals(string) ? true : "grpc-dns".equals(string)) {
            String host = clientConfiguration.getString("host");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(host)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "host can't be empty when service-discovery-mechanism is set to static or grpc-dns");
            serviceName = host;
            serviceDiscovery = this.staticServiceDiscovery(host, port);
        } else {
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(serviceName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Configuration must contain a service-name");
            serviceDiscovery = ((Discovery)Discovery$.MODULE$.apply(sys)).loadServiceDiscovery(string);
        }
        ServiceDiscovery sd = serviceDiscovery;
        return this.withConfigDefaults(serviceName, sd, port, resolveTimeout, clientConfiguration);
    }

    private GrpcClientSettings withConfigDefaults(String serviceName, ServiceDiscovery serviceDiscovery, int defaultPort, FiniteDuration resolveTimeout, Config clientConfiguration) {
        return new GrpcClientSettings(serviceName, serviceDiscovery, defaultPort, resolveTimeout, this.getOptionalString(clientConfiguration, "service-discovery.port-name"), this.getOptionalString(clientConfiguration, "service-discovery.protocol"), this.getOptionalInt(clientConfiguration, "connection-attempts"), (Option<CallCredentials>)None$.MODULE$, this.getOptionalString(clientConfiguration, "override-authority"), (Option<SslProvider>)this.getOptionalString(clientConfiguration, "ssl-provider").map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            if ("jdk".equals(string)) {
                return SslProvider.JDK;
            }
            if ("openssl".equals(string)) {
                return SslProvider.OPENSSL;
            }
            if ("openssl_refcnt".equals(string)) {
                return SslProvider.OPENSSL_REFCNT;
            }
            throw new IllegalArgumentException(new StringBuilder(78).append("ssl-provider: expected empty, 'jdk', 'openssl' or 'openssl_refcnt', but got [").append(string).append("]").toString());
        }), (Option<SSLContext>)None$.MODULE$, (Option<TrustManager>)this.getOptionalString(clientConfiguration, "trusted").map((Function1 & Serializable & scala.Serializable)certificateResourcePath -> SSLContextUtils$.MODULE$.trustManagerFromResource((String)certificateResourcePath)), this.getPotentiallyInfiniteDuration(clientConfiguration, "deadline"), this.getOptionalString(clientConfiguration, "user-agent"), clientConfiguration.getBoolean("use-tls"), this.getOptionalString(clientConfiguration, "load-balancing-policy"), clientConfiguration.getString("backend"), this.$lessinit$greater$default$18());
    }

    private Option<String> getOptionalString(Config config, String path) {
        String string = config.getString(path);
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        return new Some((Object)string);
    }

    private Option<Object> getOptionalInt(Config config, String path) {
        int n = config.getInt(path);
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Duration getPotentiallyInfiniteDuration(Config underlying, String path) {
        String string = Helpers$.MODULE$.toRootLowerCase(underlying.getString(path));
        if ("infinite".equals(string)) {
            return Duration$.MODULE$.Inf();
        }
        return Duration$.MODULE$.fromNanos(underlying.getDuration(path).toNanos());
    }

    @InternalApi
    public HardcodedServiceDiscovery staticServiceDiscovery(String host, int port) {
        return new HardcodedServiceDiscovery(ServiceDiscovery.Resolved$.MODULE$.apply(host, (Seq)new .colon.colon((Object)ServiceDiscovery.ResolvedTarget$.MODULE$.apply(host, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (Option)None$.MODULE$), (List)Nil$.MODULE$)));
    }

    private GrpcClientSettings$() {
        MODULE$ = this;
    }
}

