/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio;

import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Contract;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Internal;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.hc.core5.concurrent.FutureCallback;
import gigahorse.shaded.apache.org.apache.hc.core5.function.Callback;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.reactor.ProtocolIOSession;
import gigahorse.shaded.apache.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientH2UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final Callback<Exception> exceptionCallback;

    public ClientH2UpgradeHandler(ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, Callback<Exception> exceptionCallback) {
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.exceptionCallback = exceptionCallback;
    }

    @Override
    public void upgrade(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        ClientH2PrefaceHandler protocolNegotiator = new ClientH2PrefaceHandler(ioSession, this.http2StreamHandlerFactory, true, callback, this.exceptionCallback);
        ioSession.upgrade(protocolNegotiator);
        try {
            protocolNegotiator.connected(ioSession);
        }
        catch (IOException ex) {
            protocolNegotiator.exception(ioSession, ex);
        }
    }
}

