/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.core5.http.impl;

import gigahorse.shaded.apache.org.apache.hc.core5.function.Resolver;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpHost;
import gigahorse.shaded.apache.org.apache.hc.core5.http.URIScheme;
import java.net.InetSocketAddress;

public final class DefaultAddressResolver
implements Resolver<HttpHost, InetSocketAddress> {
    public static final DefaultAddressResolver INSTANCE = new DefaultAddressResolver();

    @Override
    public InetSocketAddress resolve(HttpHost host) {
        if (host == null) {
            return null;
        }
        int port = host.getPort();
        if (port < 0) {
            String scheme = host.getSchemeName();
            if (URIScheme.HTTP.same(scheme)) {
                port = 80;
            } else if (URIScheme.HTTPS.same(scheme)) {
                port = 443;
            }
        }
        if (host.getAddress() != null) {
            return new InetSocketAddress(host.getAddress(), port);
        }
        return new InetSocketAddress(host.getHostName(), port);
    }
}

