/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import java.net.SocketAddress;

public class NamedPipeSocketAddress
extends SocketAddress {
    private static final String NAMED_PIPE_PREFIX = "\\\\.\\pipe\\";
    private final String pipe;

    public NamedPipeSocketAddress(String pipeName) {
        this.pipe = NamedPipeSocketAddress.normalizePipeName(pipeName);
    }

    public String getPipe() {
        return this.pipe;
    }

    public boolean equals(Object object) {
        if (object instanceof NamedPipeSocketAddress) {
            return this.pipe.equals(((NamedPipeSocketAddress)object).pipe);
        }
        return false;
    }

    static String normalizePipeName(String pipeName) {
        if (pipeName.startsWith(NAMED_PIPE_PREFIX)) {
            return pipeName;
        }
        return NAMED_PIPE_PREFIX + pipeName;
    }

    static boolean isNamedPipe(String address) {
        return address.startsWith(NAMED_PIPE_PREFIX);
    }
}

